$targetName = "newyork.jpg"

$locations = @(
    Join-Path $env:USERPROFILE "Downloads"
    Join-Path $env:USERPROFILE "Desktop"
)

$found = $false

foreach ($loc in $locations) {
    $filePath = Join-Path $loc $targetName
    if (Test-Path $filePath) {
        Write-Host "[SUCCESS] Found newyork.jpg in $loc"
        $found = $true
        break
    }
}

if (-not $found) {
    Write-Host "[FAIL] newyork.jpg not found in Downloads or Desktop."
}
