$minWidth = 2048
$minHeight = 2048
$minSizeKB = 500

$locations = @(
    Join-Path $env:USERPROFILE "Downloads"
    Join-Path $env:USERPROFILE "Desktop"
)

$extensions = "*.jpg","*.jpeg","*.png"

$recentThreshold = (Get-Date).AddMinutes(-3)
$found = $false

foreach ($loc in $locations) {
    foreach ($ext in $extensions) {
        $files = Get-ChildItem -Path $loc -Filter $ext -File -ErrorAction SilentlyContinue |
            Where-Object {
                $_.LastWriteTime -gt $recentThreshold -and $_.Length -gt ($minSizeKB * 1KB)
            }

        foreach ($file in $files) {
            $info = & ffprobe -v error -select_streams v:0 -show_entries stream=width,height `
                -of csv=p=0 "$($file.FullName)" 2>$null

            if ($info) {
                $parts = $info -split ","
                $width = [int]$parts[0]
                $height = [int]$parts[1]

                if ($width -ge $minWidth -or $height -ge $minHeight) {
                    Write-Host "[SUCCESS] Found large image: $($file.Name) ($width x $height)"
                    $found = $true
                    break
                }
            }
        }
    }
    if ($found) { break }
}

if (-not $found) {
    Write-Host "[FAIL] No recent 2K forest photo found in Downloads or Desktop."
}
