$expectedNames = @(
    "bruce_mccandless_ii_during_eva_in_1984.jpg",
    "astronaut.jpg"
)

$locations = @(
    Join-Path $env:USERPROFILE "Downloads"
    Join-Path $env:USERPROFILE "Desktop"
)

$found = $false

foreach ($loc in $locations) {
    if (Test-Path $loc) {
        $files = Get-ChildItem -Path $loc -Filter *.jpg -File -ErrorAction SilentlyContinue
        foreach ($file in $files) {
            if ($expectedNames -contains $file.Name.ToLower()) {
                Write-Host "[SUCCESS] Found expected image: $($file.FullName)"
                $found = $true
                break
            }
        }
    }
    if ($found) { break }
}

if (-not $found) {
    Write-Host "[FAIL] Expected image not found in Downloads or Desktop."
}
