$targetFile = "mixkit-white-cat-lying-among-the-grasses-seen-up-close-22732-full-hd.mp4"

$locations = @(
    Join-Path $env:USERPROFILE "Downloads"
    Join-Path $env:USERPROFILE "Desktop"
)

$videoPath = $null
foreach ($loc in $locations) {
    $tryPath = Join-Path $loc $targetFile
    if (Test-Path $tryPath) {
        $videoPath = $tryPath
        break
    }
}

if (-not $videoPath) {
    Write-Host "[FAIL] Expected video not found in Downloads or Desktop."
    exit 1
}

$resolution = ffprobe -v error -select_streams v:0 -show_entries stream=width,height -of csv=p=0 "$videoPath"

if ($resolution -eq "1920,1080") {
    Write-Host "[SUCCESS] Video is found and has resolution 1920x1080."
} else {
    Write-Host "[FAIL] Video found but has wrong resolution: $resolution"
}
