# gt.ps1 -- Check if Text Cursor indicator color is pink (0x00bf00ff)

$regPath = 'HKCU:\Software\Microsoft\Accessibility\CursorIndicator'
$keyName = 'IndicatorColor'
$expected = 0x00bf00ff  # Your system's pink color value

if (-not (Test-Path $regPath)) {
    Write-Host "[FAIL] CursorIndicator registry path not found."
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host "[FAIL] IndicatorColor key not found."
    exit 1
}

if ($value -eq $expected) {
    Write-Host "[SUCCESS] Text cursor indicator color is pink (value: 0x00bf00ff)."
} else {
    Write-Host ("[FAIL] Text cursor indicator color is 0x{0:X8}, expected 0x00bf00ff." -f $value)
}
