$regPath = 'HKCU:\Software\Microsoft\Windows\CurrentVersion\ClosedCaptioning'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Caption settings registry key not found. Did you apply a caption style?'
    exit 1
}

$bgColor = Get-ItemPropertyValue -Path $regPath -Name 'BackgroundColor' -ErrorAction Stop
$fgColor = Get-ItemPropertyValue -Path $regPath -Name 'CaptionColor'    -ErrorAction Stop

$expectedBg = 5
$expectedFg = 6

if ($bgColor -eq $expectedBg -and $fgColor -eq $expectedFg) {
    Write-Host '[SUCCESS] Caption style is set to Yellow on blue.'
    exit 0
} else {
    Write-Host '[FAIL] Caption style is NOT Yellow on blue.'
    Write-Host "       BackgroundColor = $bgColor (expected $expectedBg)"
    Write-Host "       CaptionColor    = $fgColor (expected $expectedFg)"
    exit 1
}
