Add-Type -AssemblyName PresentationCore

$clipboard = [Windows.Clipboard]::GetText()

$requiredFields = @(
    "Device name",
    "Processor",
    "Installed RAM",
    "Device ID",
    "Product ID",
    "System type",
    "Pen and touch"
)

$matchedCount = ($requiredFields | Where-Object { $clipboard -match $_ }).Count
$missing = $requiredFields.Count - $matchedCount

if ($missing -le 2) {
    Write-Host "[SUCCESS] Clipboard contains at least 5 of the 7 required Device Specifications. Missing: $missing"
} else {
    Write-Host "[FAIL] Clipboard is missing too many fields. Missing: $missing"
}
