$regPath = 'HKCU:\Control Panel\International\User Profile'
$keyName = 'HttpAcceptLanguageOptOut'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Registry path not found.'
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host '[FAIL] "HttpAcceptLanguageOptOut" value not found.'
    exit 1
}

if ($value -eq 1) {
    Write-Host '[SUCCESS] Website access to language list is turned OFF (HttpAcceptLanguageOptOut = 1).'
    exit 0
} else {
    Write-Host "[FAIL] Website access is still allowed (HttpAcceptLanguageOptOut = $value)."
    exit 1
}
