$regPath = 'HKCU:\Software\Microsoft\Windows\CurrentVersion\AdvertisingInfo'
$keyName = 'Enabled'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Registry path not found. AdvertisingInfo setting is missing.'
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host '[FAIL] "Enabled" value not found in AdvertisingInfo.'
    exit 1
}

if ($value -eq 0) {
    Write-Host '[SUCCESS] Ads ID usage is disabled (Enabled = 0).'
    exit 0
} else {
    Write-Host "[FAIL] Ads ID usage is enabled (Enabled = $value)."
    exit 1
}
