$regPath = 'HKCU:\Software\Microsoft\TabletTip\1.7'
$keyName = 'EnableAutocorrection'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Registry path not found. Autocorrect setting not present.'
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host '[FAIL] "EnableAutocorrection" value not found.'
    exit 1
}

if ($value -eq 1) {
    Write-Host '[SUCCESS] Autocorrect Misspelled Words is enabled (EnableAutocorrection = 1).'
    exit 0
} else {
    Write-Host "[FAIL] Autocorrect is disabled or misconfigured (EnableAutocorrection = $value)."
    exit 1
}
