$regPath = 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Notifications\Settings\Windows.SystemToast.StartupApp'
$keyName = 'Enabled'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Registry path not found. Startup App notification setting not present.'
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host '[FAIL] "Enabled" value not found. Notifications likely not disabled.'
    exit 1
}

if ($value -eq 0) {
    Write-Host '[SUCCESS] Startup App notifications are disabled (Enabled = 0).'
    exit 0
} else {
    Write-Host "[FAIL] Startup App notifications are enabled (Enabled = $value)."
    exit 1
}
