$regPath = 'HKCU:\Software\Microsoft\Windows\CurrentVersion\StorageSense\Parameters\StoragePolicy'
$keyName = '01'

if (-not (Test-Path $regPath)) {
    Write-Host '[FAIL] Storage Sense registry path not found.'
    exit 1
}

try {
    $value = Get-ItemPropertyValue -Path $regPath -Name $keyName -ErrorAction Stop
} catch {
    Write-Host '[FAIL] Storage Sense enable value not found.'
    exit 1
}

if ($value -eq 1) {
    Write-Host '[SUCCESS] Storage Sense is turned ON (01 = 1).'
    exit 0
} else {
    Write-Host "[FAIL] Storage Sense is OFF or misconfigured (01 = $value)."
    exit 1
}
