/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgespi;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.forgespi.locating.IModDirectoryLocatorFactory;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;

public class Environment {
    private static Environment INSTANCE;
    private final IEnvironment environment;
    private final Dist dist;
    private final ModFileFactory modFileFactory;

    public static void build(IEnvironment environment) {
        if (INSTANCE != null) {
            throw new RuntimeException("Environment is a singleton");
        }
        INSTANCE = new Environment(environment);
    }

    public static Environment get() {
        return INSTANCE;
    }

    private Environment(IEnvironment setup) {
        this.environment = setup;
        this.dist = setup.getProperty(Keys.DIST.get()).orElseThrow(() -> new RuntimeException("Missing DIST in environment!"));
        this.modFileFactory = setup.getProperty(Keys.MODFILEFACTORY.get()).orElseThrow(() -> new RuntimeException("Missing MODFILEFACTORY in environment!"));
    }

    public Dist getDist() {
        return this.dist;
    }

    public ModFileFactory getModFileFactory() {
        return this.modFileFactory;
    }

    public static final class Keys {
        public static final Supplier<TypesafeMap.Key<Dist>> DIST = IEnvironment.buildKey("FORGEDIST", Dist.class);
        @Deprecated
        public static final Supplier<TypesafeMap.Key<Function<Path, IModLocator>>> MODFOLDERFACTORY = IEnvironment.buildKey("MODFOLDERFACTORY", Function.class);
        public static final Supplier<TypesafeMap.Key<IModDirectoryLocatorFactory>> MODDIRECTORYFACTORY = IEnvironment.buildKey("MODDIRFACTORY", IModDirectoryLocatorFactory.class);
        public static final Supplier<TypesafeMap.Key<ModFileFactory>> MODFILEFACTORY = IEnvironment.buildKey("MODFILEFACTORY", ModFileFactory.class);
        public static final Supplier<TypesafeMap.Key<Consumer<String>>> PROGRESSMESSAGE = IEnvironment.buildKey("PROGRESSMESSAGE", Consumer.class);
    }
}

