/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import com.minerl.multiagent.RandomHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeMagnifier;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.MobDensityTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int field_234960_b_ = (int)Math.pow(17.0, 2.0);
    private static final EntityClassification[] entityClassifications = (EntityClassification[])Stream.of(EntityClassification.values()).filter(p_234965_0_ -> p_234965_0_ != EntityClassification.MISC).toArray(EntityClassification[]::new);

    public static EntityDensityManager func_234964_a_(int p_234964_0_, Iterable<Entity> p_234964_1_, IInitialDensityAdder p_234964_2_) {
        MobDensityTracker mobdensitytracker = new MobDensityTracker();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        Iterator<Entity> iterator = p_234964_1_.iterator();
        while (iterator.hasNext()) {
            MobEntity mobentity;
            Entity entity = iterator.next();
            if (entity instanceof MobEntity && ((mobentity = (MobEntity)entity).isNoDespawnRequired() || mobentity.preventDespawn())) continue;
            Entity entity_f = entity;
            EntityClassification entityclassification = entity.getType().getClassification();
            if (entityclassification == EntityClassification.MISC) continue;
            BlockPos blockpos = entity.getPosition();
            long i = ChunkPos.asLong(blockpos.getX() >> 4, blockpos.getZ() >> 4);
            p_234964_2_.query(i, p_234971_5_ -> {
                MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(blockpos, p_234971_5_).getMobSpawnInfo().getSpawnCost(entity_f.getType());
                if (mobspawninfo$spawncosts != null) {
                    mobdensitytracker.func_234998_a_(entity_f.getPosition(), mobspawninfo$spawncosts.getEntitySpawnCost());
                }
                object2intopenhashmap.addTo(entityclassification, 1);
            });
        }
        return new EntityDensityManager(p_234964_0_, object2intopenhashmap, mobdensitytracker);
    }

    private static Biome func_234980_b_(BlockPos p_234980_0_, IChunk p_234980_1_) {
        return DefaultBiomeMagnifier.INSTANCE.getBiome(0L, p_234980_0_.getX(), p_234980_0_.getY(), p_234980_0_.getZ(), p_234980_1_.getBiomes());
    }

    public static void spawnMobs(ServerWorld world, Chunk chunk, EntityDensityManager entityDensityManager, boolean spawnPassives, boolean spawnHostiles, boolean spawnAnimals) {
        world.getProfiler().startSection("spawner");
        for (EntityClassification entityclassification : entityClassifications) {
            if (!spawnPassives && entityclassification.getPeacefulCreature() || !spawnHostiles && !entityclassification.getPeacefulCreature() || !spawnAnimals && entityclassification.getAnimal() || !entityDensityManager.func_234991_a_(entityclassification)) continue;
            WorldEntitySpawner.func_234967_a_(entityclassification, world, chunk, (p_234969_1_, p_234969_2_, p_234969_3_) -> entityDensityManager.func_234989_a_(p_234969_1_, p_234969_2_, p_234969_3_), (p_234970_1_, p_234970_2_) -> entityDensityManager.func_234990_a_(p_234970_1_, p_234970_2_));
        }
        world.getProfiler().endSection();
    }

    public static void func_234967_a_(EntityClassification p_234967_0_, ServerWorld p_234967_1_, Chunk p_234967_2_, IDensityCheck p_234967_3_, IOnSpawnDensityAdder p_234967_4_) {
        BlockPos blockpos = WorldEntitySpawner.getRandomHeight(p_234967_1_, p_234967_2_);
        if (blockpos.getY() >= 1) {
            WorldEntitySpawner.func_234966_a_(p_234967_0_, p_234967_1_, p_234967_2_, blockpos, p_234967_3_, p_234967_4_);
        }
    }

    public static void func_234966_a_(EntityClassification entityClassification, ServerWorld world, IChunk chunk, BlockPos blockPos, IDensityCheck p_234966_4_, IOnSpawnDensityAdder p_234966_5_) {
        StructureManager structuremanager = world.func_241112_a_();
        ChunkGenerator chunkgenerator = world.getChunkProvider().getChunkGenerator();
        int i = blockPos.getY();
        Random rand = world.rand;
        BlockState blockstate = chunk.getBlockState(blockPos);
        if (!blockstate.isNormalCube(chunk, blockPos)) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int j = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int l = blockPos.getX();
                int i1 = blockPos.getZ();
                int j1 = 6;
                MobSpawnInfo.Spawners mobspawninfo$spawners = null;
                ILivingEntityData ilivingentitydata = null;
                int k1 = MathHelper.ceil(rand.nextFloat() * 4.0f);
                int l1 = 0;
                for (int i2 = 0; i2 < k1; ++i2) {
                    double d2;
                    blockpos$mutable.setPos(l += rand.nextInt(6) - rand.nextInt(6), i, i1 += rand.nextInt(6) - rand.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    PlayerEntity playerentity = world.getClosestPlayer(d0, (double)i, d1, -1.0, false);
                    if (playerentity == null || !WorldEntitySpawner.func_234978_a_(world, chunk, blockpos$mutable, d2 = playerentity.getDistanceSq(d0, i, d1))) continue;
                    if (mobspawninfo$spawners == null) {
                        mobspawninfo$spawners = WorldEntitySpawner.func_234977_a_(world, structuremanager, chunkgenerator, entityClassification, rand, blockpos$mutable);
                        if (mobspawninfo$spawners == null) continue block0;
                        k1 = mobspawninfo$spawners.minCount + rand.nextInt(1 + mobspawninfo$spawners.maxCount - mobspawninfo$spawners.minCount);
                    }
                    if (!WorldEntitySpawner.func_234975_a_(world, entityClassification, structuremanager, chunkgenerator, mobspawninfo$spawners, blockpos$mutable, d2) || !p_234966_4_.test(mobspawninfo$spawners.type, blockpos$mutable, chunk)) continue;
                    MobEntity mobentity = WorldEntitySpawner.func_234973_a_(world, mobspawninfo$spawners.type);
                    if (mobentity == null) {
                        return;
                    }
                    mobentity.setLocationAndAngles(d0, i, d1, rand.nextFloat() * 360.0f, 0.0f);
                    if (!WorldEntitySpawner.func_234974_a_(world, mobentity, d2)) continue;
                    ilivingentitydata = mobentity.onInitialSpawn(world, world.getDifficultyForLocation(mobentity.getPosition()), SpawnReason.NATURAL, ilivingentitydata, null);
                    ++l1;
                    world.func_242417_l(mobentity);
                    p_234966_5_.run(mobentity, chunk);
                    if (++j >= mobentity.getMaxSpawnedInChunk()) {
                        return;
                    }
                    if (mobentity.isMaxGroupSize(l1)) continue block0;
                }
            }
        }
    }

    private static boolean func_234978_a_(ServerWorld p_234978_0_, IChunk p_234978_1_, BlockPos.Mutable p_234978_2_, double p_234978_3_) {
        if (p_234978_3_ <= 576.0) {
            return false;
        }
        if (p_234978_0_.getSpawnPoint().withinDistance(new Vector3d((double)p_234978_2_.getX() + 0.5, p_234978_2_.getY(), (double)p_234978_2_.getZ() + 0.5), 24.0)) {
            return false;
        }
        ChunkPos chunkpos = new ChunkPos(p_234978_2_);
        return Objects.equals(chunkpos, p_234978_1_.getPos()) || p_234978_0_.getChunkProvider().isChunkLoaded(chunkpos);
    }

    private static boolean func_234975_a_(ServerWorld p_234975_0_, EntityClassification p_234975_1_, StructureManager p_234975_2_, ChunkGenerator p_234975_3_, MobSpawnInfo.Spawners p_234975_4_, BlockPos.Mutable p_234975_5_, double p_234975_6_) {
        EntityType<?> entitytype = p_234975_4_.type;
        if (entitytype.getClassification() == EntityClassification.MISC) {
            return false;
        }
        if (!entitytype.func_225437_d() && p_234975_6_ > (double)(entitytype.getClassification().getInstantDespawnDistance() * entitytype.getClassification().getInstantDespawnDistance())) {
            return false;
        }
        if (entitytype.isSummonable() && WorldEntitySpawner.func_234976_a_(p_234975_0_, p_234975_2_, p_234975_3_, p_234975_1_, p_234975_4_, p_234975_5_)) {
            EntitySpawnPlacementRegistry.PlacementType entityspawnplacementregistry$placementtype = EntitySpawnPlacementRegistry.getPlacementType(entitytype);
            if (!WorldEntitySpawner.canCreatureTypeSpawnAtLocation(entityspawnplacementregistry$placementtype, p_234975_0_, p_234975_5_, entitytype)) {
                return false;
            }
            if (!EntitySpawnPlacementRegistry.canSpawnEntity(entitytype, p_234975_0_, SpawnReason.NATURAL, p_234975_5_, p_234975_0_.rand)) {
                return false;
            }
            return p_234975_0_.hasNoCollisions(entitytype.getBoundingBoxWithSizeApplied((double)p_234975_5_.getX() + 0.5, p_234975_5_.getY(), (double)p_234975_5_.getZ() + 0.5));
        }
        return false;
    }

    @Nullable
    private static MobEntity func_234973_a_(ServerWorld p_234973_0_, EntityType<?> p_234973_1_) {
        try {
            Object entity = p_234973_1_.create(p_234973_0_);
            if (!(entity instanceof MobEntity)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.ENTITY_TYPE.getKey(p_234973_1_));
            }
            return (MobEntity)entity;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
    }

    private static boolean func_234974_a_(ServerWorld p_234974_0_, MobEntity p_234974_1_, double p_234974_2_) {
        if (p_234974_2_ > (double)(p_234974_1_.getType().getClassification().getInstantDespawnDistance() * p_234974_1_.getType().getClassification().getInstantDespawnDistance()) && p_234974_1_.canDespawn(p_234974_2_)) {
            return false;
        }
        return p_234974_1_.canSpawn(p_234974_0_, SpawnReason.NATURAL) && p_234974_1_.isNotColliding(p_234974_0_);
    }

    @Nullable
    private static MobSpawnInfo.Spawners func_234977_a_(ServerWorld p_234977_0_, StructureManager p_234977_1_, ChunkGenerator p_234977_2_, EntityClassification p_234977_3_, Random p_234977_4_, BlockPos p_234977_5_) {
        Biome biome = p_234977_0_.getBiome(p_234977_5_);
        if (p_234977_3_ == EntityClassification.WATER_AMBIENT && biome.getCategory() == Biome.Category.RIVER && p_234977_4_.nextFloat() < 0.98f) {
            return null;
        }
        List<MobSpawnInfo.Spawners> list = WorldEntitySpawner.func_241463_a_(p_234977_0_, p_234977_1_, p_234977_2_, p_234977_3_, p_234977_5_, biome);
        return list.isEmpty() ? null : WeightedRandom.getRandomItem(p_234977_4_, list);
    }

    private static boolean func_234976_a_(ServerWorld p_234976_0_, StructureManager p_234976_1_, ChunkGenerator p_234976_2_, EntityClassification p_234976_3_, MobSpawnInfo.Spawners p_234976_4_, BlockPos p_234976_5_) {
        return WorldEntitySpawner.func_241463_a_(p_234976_0_, p_234976_1_, p_234976_2_, p_234976_3_, p_234976_5_, null).contains(p_234976_4_);
    }

    private static List<MobSpawnInfo.Spawners> func_241463_a_(ServerWorld p_241463_0_, StructureManager p_241463_1_, ChunkGenerator p_241463_2_, EntityClassification p_241463_3_, BlockPos p_241463_4_, @Nullable Biome p_241463_5_) {
        return p_241463_3_ == EntityClassification.MONSTER && p_241463_0_.getBlockState(p_241463_4_.down()).getBlock() == Blocks.NETHER_BRICKS && p_241463_1_.func_235010_a_(p_241463_4_, false, Structure.FORTRESS).isValid() ? Structure.FORTRESS.getSpawnList() : p_241463_2_.func_230353_a_(p_241463_5_ != null ? p_241463_5_ : p_241463_0_.getBiome(p_241463_4_), p_241463_1_, p_241463_3_, p_241463_4_);
    }

    private static BlockPos getRandomHeight(World worldIn, Chunk chunk) {
        ChunkPos chunkpos = chunk.getPos();
        Random rand = RandomHelper.getRandom("spawner" + chunkpos, 0L);
        int i = chunkpos.getXStart() + rand.nextInt(16);
        int j = chunkpos.getZStart() + rand.nextInt(16);
        int k = chunk.getTopBlockY(Heightmap.Type.WORLD_SURFACE, i, j) + 1;
        int l = rand.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static boolean func_234968_a_(IBlockReader p_234968_0_, BlockPos p_234968_1_, BlockState p_234968_2_, FluidState p_234968_3_, EntityType<?> p_234968_4_) {
        if (p_234968_2_.hasOpaqueCollisionShape(p_234968_0_, p_234968_1_)) {
            return false;
        }
        if (p_234968_2_.canProvidePower()) {
            return false;
        }
        if (!p_234968_3_.isEmpty()) {
            return false;
        }
        if (p_234968_2_.isIn(BlockTags.PREVENT_MOB_SPAWNING_INSIDE)) {
            return false;
        }
        return !p_234968_4_.func_233597_a_(p_234968_2_);
    }

    public static boolean canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityTypeIn != null && worldIn.getWorldBorder().contains(pos)) {
            BlockState blockstate = worldIn.getBlockState(pos);
            FluidState fluidstate = worldIn.getFluidState(pos);
            BlockPos blockpos = pos.up();
            BlockPos blockpos1 = pos.down();
            switch (placeType) {
                case IN_WATER: {
                    return fluidstate.isTagged(FluidTags.WATER) && worldIn.getFluidState(blockpos1).isTagged(FluidTags.WATER) && !worldIn.getBlockState(blockpos).isNormalCube(worldIn, blockpos);
                }
                case IN_LAVA: {
                    return fluidstate.isTagged(FluidTags.LAVA);
                }
            }
            BlockState blockstate1 = worldIn.getBlockState(blockpos1);
            if (!blockstate1.canEntitySpawn(worldIn, blockpos1, entityTypeIn)) {
                return false;
            }
            return WorldEntitySpawner.func_234968_a_(worldIn, pos, blockstate, fluidstate, entityTypeIn) && WorldEntitySpawner.func_234968_a_(worldIn, blockpos, worldIn.getBlockState(blockpos), worldIn.getFluidState(blockpos), entityTypeIn);
        }
        return false;
    }

    public static void performWorldGenSpawning(IServerWorld worldIn, Biome biomeIn, int centerX, int centerZ, Random diameterX) {
        MobSpawnInfo mobspawninfo = biomeIn.getMobSpawnInfo();
        List<MobSpawnInfo.Spawners> list = mobspawninfo.getSpawners(EntityClassification.CREATURE);
        if (!list.isEmpty()) {
            int i = centerX << 4;
            int j = centerZ << 4;
            while (diameterX.nextFloat() < mobspawninfo.getCreatureSpawnProbability()) {
                MobSpawnInfo.Spawners mobspawninfo$spawners = WeightedRandom.getRandomItem(diameterX, list);
                int k = mobspawninfo$spawners.minCount + diameterX.nextInt(1 + mobspawninfo$spawners.maxCount - mobspawninfo$spawners.minCount);
                ILivingEntityData ilivingentitydata = null;
                int l = i + diameterX.nextInt(16);
                int i1 = j + diameterX.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = WorldEntitySpawner.getTopSolidOrLiquidBlock(worldIn, mobspawninfo$spawners.type, l, i1);
                        if (mobspawninfo$spawners.type.isSummonable() && WorldEntitySpawner.canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.getPlacementType(mobspawninfo$spawners.type), worldIn, blockpos, mobspawninfo$spawners.type)) {
                            MobEntity mobentity;
                            Object entity;
                            float f = mobspawninfo$spawners.type.getWidth();
                            double d0 = MathHelper.clamp((double)l, (double)i + (double)f, (double)i + 16.0 - (double)f);
                            double d1 = MathHelper.clamp((double)i1, (double)j + (double)f, (double)j + 16.0 - (double)f);
                            if (!worldIn.hasNoCollisions(mobspawninfo$spawners.type.getBoundingBoxWithSizeApplied(d0, blockpos.getY(), d1)) || !EntitySpawnPlacementRegistry.canSpawnEntity(mobspawninfo$spawners.type, worldIn, SpawnReason.CHUNK_GENERATION, new BlockPos(d0, (double)blockpos.getY(), d1), worldIn.getRandom())) continue;
                            try {
                                entity = mobspawninfo$spawners.type.create(worldIn.getWorld());
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            ((Entity)entity).setLocationAndAngles(d0, blockpos.getY(), d1, diameterX.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof MobEntity && (mobentity = (MobEntity)entity).canSpawn(worldIn, SpawnReason.CHUNK_GENERATION) && mobentity.isNotColliding(worldIn)) {
                                ilivingentitydata = mobentity.onInitialSpawn(worldIn, worldIn.getDifficultyForLocation(mobentity.getPosition()), SpawnReason.CHUNK_GENERATION, ilivingentitydata, null);
                                worldIn.func_242417_l(mobentity);
                                flag = true;
                            }
                        }
                        l += diameterX.nextInt(5) - diameterX.nextInt(5);
                        i1 += diameterX.nextInt(5) - diameterX.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                            i1 = k1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopSolidOrLiquidBlock(IWorldReader worldIn, EntityType<?> p_208498_1_, int x, int z) {
        Vector3i blockpos;
        int i = worldIn.getHeight(EntitySpawnPlacementRegistry.func_209342_b(p_208498_1_), x, z);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, i, z);
        if (worldIn.getDimensionType().getHasCeiling()) {
            do {
                blockpos$mutable.move(Direction.DOWN);
            } while (!worldIn.getBlockState(blockpos$mutable).isAir());
            do {
                blockpos$mutable.move(Direction.DOWN);
            } while (worldIn.getBlockState(blockpos$mutable).isAir() && blockpos$mutable.getY() > 0);
        }
        if (EntitySpawnPlacementRegistry.getPlacementType(p_208498_1_) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && worldIn.getBlockState((BlockPos)(blockpos = blockpos$mutable.down())).allowsMovement(worldIn, (BlockPos)blockpos, PathType.LAND)) {
            return blockpos;
        }
        return blockpos$mutable.toImmutable();
    }

    @FunctionalInterface
    public static interface IOnSpawnDensityAdder {
        public void run(MobEntity var1, IChunk var2);
    }

    @FunctionalInterface
    public static interface IInitialDensityAdder {
        public void query(long var1, Consumer<Chunk> var3);
    }

    @FunctionalInterface
    public static interface IDensityCheck {
        public boolean test(EntityType<?> var1, BlockPos var2, IChunk var3);
    }

    public static class EntityDensityManager {
        private final int field_234981_a_;
        private final Object2IntOpenHashMap<EntityClassification> field_234982_b_;
        private final MobDensityTracker field_234983_c_;
        private final Object2IntMap<EntityClassification> field_234984_d_;
        @Nullable
        private BlockPos field_234985_e_;
        @Nullable
        private EntityType<?> field_234986_f_;
        private double field_234987_g_;

        private EntityDensityManager(int p_i231621_1_, Object2IntOpenHashMap<EntityClassification> p_i231621_2_, MobDensityTracker p_i231621_3_) {
            this.field_234981_a_ = p_i231621_1_;
            this.field_234982_b_ = p_i231621_2_;
            this.field_234983_c_ = p_i231621_3_;
            this.field_234984_d_ = Object2IntMaps.unmodifiable(p_i231621_2_);
        }

        private boolean func_234989_a_(EntityType<?> p_234989_1_, BlockPos p_234989_2_, IChunk p_234989_3_) {
            double d0;
            this.field_234985_e_ = p_234989_2_;
            this.field_234986_f_ = p_234989_1_;
            MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(p_234989_2_, p_234989_3_).getMobSpawnInfo().getSpawnCost(p_234989_1_);
            if (mobspawninfo$spawncosts == null) {
                this.field_234987_g_ = 0.0;
                return true;
            }
            this.field_234987_g_ = d0 = mobspawninfo$spawncosts.getEntitySpawnCost();
            double d1 = this.field_234983_c_.func_234999_b_(p_234989_2_, d0);
            return d1 <= mobspawninfo$spawncosts.getMaxSpawnCost();
        }

        private void func_234990_a_(MobEntity p_234990_1_, IChunk p_234990_2_) {
            MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts;
            EntityType<?> entitytype = p_234990_1_.getType();
            BlockPos blockpos = p_234990_1_.getPosition();
            double d0 = blockpos.equals(this.field_234985_e_) && entitytype == this.field_234986_f_ ? this.field_234987_g_ : ((mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(blockpos, p_234990_2_).getMobSpawnInfo().getSpawnCost(entitytype)) != null ? mobspawninfo$spawncosts.getEntitySpawnCost() : 0.0);
            this.field_234983_c_.func_234998_a_(blockpos, d0);
            this.field_234982_b_.addTo(entitytype.getClassification(), 1);
        }

        public int func_234988_a_() {
            return this.field_234981_a_;
        }

        public Object2IntMap<EntityClassification> func_234995_b_() {
            return this.field_234984_d_;
        }

        private boolean func_234991_a_(EntityClassification p_234991_1_) {
            int i = p_234991_1_.getMaxNumberOfCreature() * this.field_234981_a_ / field_234960_b_;
            return this.field_234982_b_.getInt(p_234991_1_) < i;
        }
    }
}

