/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanRuinStructure
extends Structure<OceanRuinConfig> {
    public OceanRuinStructure(Codec<OceanRuinConfig> p_i232109_1_) {
        super(p_i232109_1_);
    }

    @Override
    public Structure.IStartFactory<OceanRuinConfig> getStartFactory() {
        return Start::new;
    }

    public static enum Type implements IStringSerializable
    {
        WARM("warm"),
        COLD("cold");

        public static final Codec<Type> field_236998_c_;
        private static final Map<String, Type> BY_NAME;
        private final String name;

        private Type(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static Type getType(String nameIn) {
            return BY_NAME.get(nameIn);
        }

        @Override
        public String getString() {
            return this.name;
        }

        static {
            field_236998_c_ = IStringSerializable.createEnumCodec(Type::values, Type::getType);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_215134_0_ -> p_215134_0_));
        }
    }

    public static class Start
    extends StructureStart<OceanRuinConfig> {
        public Start(Structure<OceanRuinConfig> p_i225875_1_, int p_i225875_2_, int p_i225875_3_, MutableBoundingBox p_i225875_4_, int p_i225875_5_, long p_i225875_6_) {
            super(p_i225875_1_, p_i225875_2_, p_i225875_3_, p_i225875_4_, p_i225875_5_, p_i225875_6_);
        }

        @Override
        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator p_230364_2_, TemplateManager p_230364_3_, int p_230364_4_, int p_230364_5_, Biome p_230364_6_, OceanRuinConfig p_230364_7_) {
            int i = p_230364_4_ * 16;
            int j = p_230364_5_ * 16;
            BlockPos blockpos = new BlockPos(i, 90, j);
            Rotation rotation = Rotation.randomRotation(this.rand);
            OceanRuinPieces.func_204041_a(p_230364_3_, blockpos, rotation, this.components, this.rand, p_230364_7_);
            this.recalculateStructureSize();
        }
    }
}

