/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageSiege
implements ISpecialSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int siegeCount;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    @Override
    public int func_230253_a_(ServerWorld p_230253_1_, boolean p_230253_2_, boolean p_230253_3_) {
        if (!p_230253_1_.isDaytime() && p_230253_2_) {
            float f = p_230253_1_.func_242415_f(0.0f);
            if ((double)f == 0.5) {
                State state = this.siegeState = p_230253_1_.rand.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.siegeState == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.hasSetupSiege) {
                if (!this.trySetupSiege(p_230253_1_)) {
                    return 0;
                }
                this.hasSetupSiege = true;
            }
            if (this.nextSpawnTime > 0) {
                --this.nextSpawnTime;
                return 0;
            }
            this.nextSpawnTime = 2;
            if (this.siegeCount > 0) {
                this.spawnZombie(p_230253_1_);
                --this.siegeCount;
            } else {
                this.siegeState = State.SIEGE_DONE;
            }
            return 1;
        }
        this.siegeState = State.SIEGE_DONE;
        this.hasSetupSiege = false;
        return 0;
    }

    private boolean trySetupSiege(ServerWorld world) {
        for (PlayerEntity playerEntity : world.getPlayers()) {
            BlockPos blockpos;
            if (playerEntity.isSpectator() || !world.isVillage(blockpos = playerEntity.getPosition()) || world.getBiome(blockpos).getCategory() == Biome.Category.MUSHROOM) continue;
            for (int i = 0; i < 10; ++i) {
                float f = world.rand.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = blockpos.getX() + MathHelper.floor(MathHelper.cos(f) * 32.0f);
                this.spawnY = blockpos.getY();
                this.spawnZ = blockpos.getZ() + MathHelper.floor(MathHelper.sin(f) * 32.0f);
                if (this.findRandomSpawnPos(world, new BlockPos(this.spawnX, this.spawnY, this.spawnZ)) == null) continue;
                this.nextSpawnTime = 0;
                this.siegeCount = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void spawnZombie(ServerWorld world) {
        Vector3d vector3d = this.findRandomSpawnPos(world, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vector3d != null) {
            ZombieEntity zombieentity;
            try {
                zombieentity = new ZombieEntity(world);
                zombieentity.onInitialSpawn(world, world.getDifficultyForLocation(zombieentity.getPosition()), SpawnReason.EVENT, null, null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to create zombie for village siege at {}", (Object)vector3d, (Object)exception);
                return;
            }
            zombieentity.setLocationAndAngles(vector3d.x, vector3d.y, vector3d.z, world.rand.nextFloat() * 360.0f, 0.0f);
            world.func_242417_l(zombieentity);
        }
    }

    @Nullable
    private Vector3d findRandomSpawnPos(ServerWorld world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.getX() + world.rand.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(j, l = world.getHeight(Heightmap.Type.WORLD_SURFACE, j, k = pos.getZ() + world.rand.nextInt(16) - 8), k);
            if (!world.isVillage(blockpos) || !MonsterEntity.canMonsterSpawnInLight(EntityType.ZOMBIE, world, SpawnReason.EVENT, blockpos, world.rand)) continue;
            return Vector3d.copyCenteredHorizontally(blockpos);
        }
        return null;
    }

    static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

