/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.math.MathHelper;

public class IntIdentityHashBiMap<K>
implements IObjectIntIterable<K> {
    private static final Object EMPTY = null;
    private K[] values;
    private int[] intKeys;
    private K[] byId;
    private int nextFreeIndex;
    private int mapSize;

    public IntIdentityHashBiMap(int initialCapacity) {
        initialCapacity = (int)((float)initialCapacity / 0.8f);
        this.values = new Object[initialCapacity];
        this.intKeys = new int[initialCapacity];
        this.byId = new Object[initialCapacity];
    }

    @Override
    public int getId(@Nullable K value) {
        return this.getValue(this.getIndex(value, this.hashObject(value)));
    }

    @Override
    @Nullable
    public K getByValue(int value) {
        return value >= 0 && value < this.byId.length ? (K)this.byId[value] : null;
    }

    private int getValue(int key) {
        return key == -1 ? -1 : this.intKeys[key];
    }

    public int add(K objectIn) {
        int i = this.nextId();
        this.put(objectIn, i);
        return i;
    }

    private int nextId() {
        while (this.nextFreeIndex < this.byId.length && this.byId[this.nextFreeIndex] != null) {
            ++this.nextFreeIndex;
        }
        return this.nextFreeIndex;
    }

    private void grow(int capacity) {
        K[] ak = this.values;
        int[] aint = this.intKeys;
        this.values = new Object[capacity];
        this.intKeys = new int[capacity];
        this.byId = new Object[capacity];
        this.nextFreeIndex = 0;
        this.mapSize = 0;
        for (int i = 0; i < ak.length; ++i) {
            if (ak[i] == null) continue;
            this.put(ak[i], aint[i]);
        }
    }

    public void put(K objectIn, int intKey) {
        int i = Math.max(intKey, this.mapSize + 1);
        if ((float)i >= (float)this.values.length * 0.8f) {
            int j;
            for (j = this.values.length << 1; j < intKey; j <<= 1) {
            }
            this.grow(j);
        }
        int k = this.findEmpty(this.hashObject(objectIn));
        this.values[k] = objectIn;
        this.intKeys[k] = intKey;
        this.byId[intKey] = objectIn;
        ++this.mapSize;
        if (intKey == this.nextFreeIndex) {
            ++this.nextFreeIndex;
        }
    }

    private int hashObject(@Nullable K obectIn) {
        return (MathHelper.hash(System.identityHashCode(obectIn)) & Integer.MAX_VALUE) % this.values.length;
    }

    private int getIndex(@Nullable K objectIn, int startIndex) {
        for (int i = startIndex; i < this.values.length; ++i) {
            if (this.values[i] == objectIn) {
                return i;
            }
            if (this.values[i] != EMPTY) continue;
            return -1;
        }
        for (int j = 0; j < startIndex; ++j) {
            if (this.values[j] == objectIn) {
                return j;
            }
            if (this.values[j] != EMPTY) continue;
            return -1;
        }
        return -1;
    }

    private int findEmpty(int startIndex) {
        for (int i = startIndex; i < this.values.length; ++i) {
            if (this.values[i] != EMPTY) continue;
            return i;
        }
        for (int j = 0; j < startIndex; ++j) {
            if (this.values[j] != EMPTY) continue;
            return j;
        }
        throw new RuntimeException("Overflowed :(");
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.filter(Iterators.forArray(this.byId), Predicates.notNull());
    }

    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.byId, null);
        this.nextFreeIndex = 0;
        this.mapSize = 0;
    }

    public int size() {
        return this.mapSize;
    }
}

