/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class BellTileEntity
extends TileEntity
implements ITickableTileEntity {
    private long ringTime;
    public int ringingTicks;
    public boolean isRinging;
    public Direction ringDirection;
    private List<LivingEntity> entitiesAtRing;
    private boolean shouldReveal;
    private int revealWarmup;

    public BellTileEntity() {
        super(TileEntityType.BELL);
    }

    @Override
    public boolean receiveClientEvent(int id, int type) {
        if (id == 1) {
            this.func_213941_c();
            this.revealWarmup = 0;
            this.ringDirection = Direction.byIndex(type);
            this.ringingTicks = 0;
            this.isRinging = true;
            return true;
        }
        return super.receiveClientEvent(id, type);
    }

    @Override
    public void tick() {
        if (this.isRinging) {
            ++this.ringingTicks;
        }
        if (this.ringingTicks >= 50) {
            this.isRinging = false;
            this.ringingTicks = 0;
        }
        if (this.ringingTicks >= 5 && this.revealWarmup == 0 && this.hasRaidersNearby()) {
            this.shouldReveal = true;
            this.resonate();
        }
        if (this.shouldReveal) {
            if (this.revealWarmup < 40) {
                ++this.revealWarmup;
            } else {
                this.glowRaiders(this.world);
                this.addRaiderParticles(this.world);
                this.shouldReveal = false;
            }
        }
    }

    private void resonate() {
        this.world.playSound(null, this.getPos(), SoundEvents.BLOCK_BELL_RESONATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void ring(Direction p_213939_1_) {
        BlockPos blockpos = this.getPos();
        this.ringDirection = p_213939_1_;
        if (this.isRinging) {
            this.ringingTicks = 0;
        } else {
            this.isRinging = true;
        }
        this.world.addBlockEvent(blockpos, this.getBlockState().getBlock(), 1, p_213939_1_.getIndex());
    }

    private void func_213941_c() {
        BlockPos blockpos = this.getPos();
        if (this.world.getGameTime() > this.ringTime + 60L || this.entitiesAtRing == null) {
            this.ringTime = this.world.getGameTime();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos).grow(48.0);
            this.entitiesAtRing = this.world.getEntitiesWithinAABB(LivingEntity.class, axisalignedbb);
        }
        if (!this.world.isRemote) {
            for (LivingEntity livingentity : this.entitiesAtRing) {
                if (!livingentity.isAlive() || livingentity.removed || !blockpos.withinDistance(livingentity.getPositionVec(), 32.0)) continue;
                livingentity.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.world.getGameTime());
            }
        }
    }

    private boolean hasRaidersNearby() {
        BlockPos blockpos = this.getPos();
        for (LivingEntity livingentity : this.entitiesAtRing) {
            if (!livingentity.isAlive() || livingentity.removed || !blockpos.withinDistance(livingentity.getPositionVec(), 32.0) || !livingentity.getType().isContained(EntityTypeTags.RAIDERS)) continue;
            return true;
        }
        return false;
    }

    private void glowRaiders(World p_222828_1_) {
        if (!p_222828_1_.isRemote) {
            this.entitiesAtRing.stream().filter(this::isNearbyRaider).forEach(this::glow);
        }
    }

    private void addRaiderParticles(World p_222826_1_) {
        if (p_222826_1_.isRemote) {
            BlockPos blockpos = this.getPos();
            MutableInt mutableint = new MutableInt(16700985);
            int i = (int)this.entitiesAtRing.stream().filter(p_222829_1_ -> blockpos.withinDistance(p_222829_1_.getPositionVec(), 48.0)).count();
            this.entitiesAtRing.stream().filter(this::isNearbyRaider).forEach(p_235655_4_ -> {
                float f = 1.0f;
                float f1 = MathHelper.sqrt((p_235655_4_.getPosX() - (double)blockpos.getX()) * (p_235655_4_.getPosX() - (double)blockpos.getX()) + (p_235655_4_.getPosZ() - (double)blockpos.getZ()) * (p_235655_4_.getPosZ() - (double)blockpos.getZ()));
                double d0 = (double)((float)blockpos.getX() + 0.5f) + (double)(1.0f / f1) * (p_235655_4_.getPosX() - (double)blockpos.getX());
                double d1 = (double)((float)blockpos.getZ() + 0.5f) + (double)(1.0f / f1) * (p_235655_4_.getPosZ() - (double)blockpos.getZ());
                int j = MathHelper.clamp((i - 21) / -2, 3, 15);
                for (int k = 0; k < j; ++k) {
                    int l = mutableint.addAndGet(5);
                    double d2 = (double)ColorHelper.PackedColor.getRed(l) / 255.0;
                    double d3 = (double)ColorHelper.PackedColor.getGreen(l) / 255.0;
                    double d4 = (double)ColorHelper.PackedColor.getBlue(l) / 255.0;
                    p_222826_1_.addParticle(ParticleTypes.ENTITY_EFFECT, d0, (float)blockpos.getY() + 0.5f, d1, d2, d3, d4);
                }
            });
        }
    }

    private boolean isNearbyRaider(LivingEntity p_222832_1_) {
        return p_222832_1_.isAlive() && !p_222832_1_.removed && this.getPos().withinDistance(p_222832_1_.getPositionVec(), 48.0) && p_222832_1_.getType().isContained(EntityTypeTags.RAIDERS);
    }

    private void glow(LivingEntity p_222827_1_) {
        p_222827_1_.addPotionEffect(new EffectInstance(Effects.GLOWING, 60));
    }
}

