/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.text.ITextComponent;

public abstract class BanEntry<T>
extends UserListEntry<T> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    protected final Date banStartDate;
    protected final String bannedBy;
    protected final Date banEndDate;
    protected final String reason;

    public BanEntry(T valueIn, @Nullable Date startDate, @Nullable String banner, @Nullable Date endDate, @Nullable String banReason) {
        super(valueIn);
        this.banStartDate = startDate == null ? new Date() : startDate;
        this.bannedBy = banner == null ? "(Unknown)" : banner;
        this.banEndDate = endDate;
        this.reason = banReason == null ? "Banned by an operator." : banReason;
    }

    protected BanEntry(T valueIn, JsonObject json) {
        super(valueIn);
        Date date1;
        Date date;
        try {
            date = json.has("created") ? DATE_FORMAT.parse(json.get("created").getAsString()) : new Date();
        }
        catch (ParseException parseexception1) {
            date = new Date();
        }
        this.banStartDate = date;
        this.bannedBy = json.has("source") ? json.get("source").getAsString() : "(Unknown)";
        try {
            date1 = json.has("expires") ? DATE_FORMAT.parse(json.get("expires").getAsString()) : null;
        }
        catch (ParseException parseexception) {
            date1 = null;
        }
        this.banEndDate = date1;
        this.reason = json.has("reason") ? json.get("reason").getAsString() : "Banned by an operator.";
    }

    public String getBannedBy() {
        return this.bannedBy;
    }

    public Date getBanEndDate() {
        return this.banEndDate;
    }

    public String getBanReason() {
        return this.reason;
    }

    public abstract ITextComponent getDisplayName();

    @Override
    boolean hasBanExpired() {
        return this.banEndDate == null ? false : this.banEndDate.before(new Date());
    }

    @Override
    protected void onSerialization(JsonObject data) {
        data.addProperty("created", DATE_FORMAT.format(this.banStartDate));
        data.addProperty("source", this.bannedBy);
        data.addProperty("expires", this.banEndDate == null ? "forever" : DATE_FORMAT.format(this.banEndDate));
        data.addProperty("reason", this.reason);
    }
}

