/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SessionLockManager
implements AutoCloseable {
    private final FileChannel fileChannel;
    private final FileLock fileLock;
    private static final ByteBuffer BYTE_BUFFER;

    public static SessionLockManager getDirLock(Path p) throws IOException {
        Path path = p.resolve("session.lock");
        if (!Files.isDirectory(p, new LinkOption[0])) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        FileChannel filechannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            filechannel.write(BYTE_BUFFER.duplicate());
            filechannel.force(true);
            FileLock filelock = filechannel.tryLock();
            if (filelock == null) {
                throw AlreadyLockedException.func_233000_a_(path);
            }
            return new SessionLockManager(filechannel, filelock);
        }
        catch (IOException ioexception1) {
            try {
                filechannel.close();
            }
            catch (IOException ioexception) {
                ioexception1.addSuppressed(ioexception);
            }
            throw ioexception1;
        }
    }

    private SessionLockManager(FileChannel fileChannel, FileLock fileLock) {
        this.fileChannel = fileChannel;
        this.fileLock = fileLock;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fileLock.isValid()) {
                this.fileLock.release();
            }
        }
        finally {
            if (this.fileChannel.isOpen()) {
                this.fileChannel.close();
            }
        }
    }

    public boolean isLockValid() {
        return this.fileLock.isValid();
    }

    /*
     * Exception decompiling
     */
    @OnlyIn(value=Dist.CLIENT)
    public static boolean isUnlocked(Path p) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        byte[] abyte = "\u2603".getBytes(Charsets.UTF_8);
        BYTE_BUFFER = ByteBuffer.allocateDirect(abyte.length);
        BYTE_BUFFER.put(abyte);
        ((Buffer)BYTE_BUFFER).flip();
    }

    public static class AlreadyLockedException
    extends IOException {
        private AlreadyLockedException(Path p_i231438_1_, String p_i231438_2_) {
            super(p_i231438_1_.toAbsolutePath() + ": " + p_i231438_2_);
        }

        public static AlreadyLockedException func_233000_a_(Path p_233000_0_) {
            return new AlreadyLockedException(p_233000_0_, "already locked (possibly by other Minecraft instance?)");
        }
    }
}

