/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class JavaResourcePack
implements IResourcePack {
    private Set<String> resources;
    private Set<String> namespaces;
    private final String index = "index.txt";

    public JavaResourcePack() {
        try {
            this.resources = IOUtils.readLines(this.getClass().getClassLoader().getResourceAsStream("index.txt")).stream().collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.namespaces = this.resources.stream().map(s -> JavaResourcePack.getResourceLocation(s).getNamespace()).collect(Collectors.toSet());
    }

    @Override
    public InputStream getRootResourceStream(String fileName) throws IOException {
        return null;
    }

    @Override
    public InputStream getResourceStream(ResourcePackType type, ResourceLocation location) throws IOException {
        return this.getClass().getClassLoader().getResourceAsStream(JavaResourcePack.pathjoin(location.getNamespace(), location.getPath()));
    }

    @Override
    public Collection<ResourceLocation> getAllResourceLocations(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        return this.resources.stream().filter(s -> s.startsWith(JavaResourcePack.pathjoin(namespaceIn, pathIn))).filter(filterIn).map(s -> JavaResourcePack.getResourceLocation(s)).collect(Collectors.toList());
    }

    private static ResourceLocation getResourceLocation(String path) {
        String[] split = path.split("/");
        if (split.length < 2) {
            return new ResourceLocation(path);
        }
        String namespace = split[0];
        String resourcePath = path.substring(namespace.length() + 1);
        return new ResourceLocation(namespace, resourcePath);
    }

    @Override
    public boolean resourceExists(ResourcePackType type, ResourceLocation location) {
        return this.resources.contains(JavaResourcePack.pathjoin(location.getNamespace(), location.getPath()));
    }

    @Override
    public Set<String> getResourceNamespaces(ResourcePackType type) {
        return this.namespaces;
    }

    @Override
    @Nullable
    public <T> T getMetadata(IMetadataSectionSerializer<T> deserializer) throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return "JavaPack";
    }

    @Override
    public void close() {
    }

    private static String pathjoin(String ... args) {
        return String.join((CharSequence)"/", args);
    }
}

