/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThread;
import net.minecraft.network.rcon.RConUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientThread
extends RConThread {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean loggedIn;
    private final Socket clientSocket;
    private final byte[] buffer = new byte[1460];
    private final String rconPassword;
    private final IServer field_232651_i_;

    ClientThread(IServer p_i50687_1_, String p_i50687_2_, Socket p_i50687_3_) {
        super("RCON Client " + p_i50687_3_.getInetAddress());
        this.field_232651_i_ = p_i50687_1_;
        this.clientSocket = p_i50687_3_;
        try {
            this.clientSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            this.running = false;
        }
        this.rconPassword = p_i50687_2_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block14: while (true) {
                if (!this.running) {
                    return;
                }
                BufferedInputStream bufferedinputstream = new BufferedInputStream(this.clientSocket.getInputStream());
                int i = bufferedinputstream.read(this.buffer, 0, 1460);
                if (10 > i) break;
                int j = 0;
                int k = RConUtils.getBytesAsLEInt(this.buffer, 0, i);
                if (k != i - 4) {
                    return;
                }
                int l = RConUtils.getBytesAsLEInt(this.buffer, j += 4, i);
                int i1 = RConUtils.getRemainingBytesAsLEInt(this.buffer, j += 4);
                j += 4;
                switch (i1) {
                    case 2: {
                        if (this.loggedIn) {
                            String s1 = RConUtils.getBytesAsString(this.buffer, j, i);
                            try {
                                this.sendMultipacketResponse(l, this.field_232651_i_.handleRConCommand(s1));
                            }
                            catch (Exception exception) {
                                this.sendMultipacketResponse(l, "Error executing: " + s1 + " (" + exception.getMessage() + ")");
                            }
                            continue block14;
                        }
                        this.sendLoginFailedResponse();
                        continue block14;
                    }
                    case 3: {
                        String s = RConUtils.getBytesAsString(this.buffer, j, i);
                        int j1 = j + s.length();
                        if (!s.isEmpty() && s.equals(this.rconPassword)) {
                            this.loggedIn = true;
                            this.sendResponse(l, 2, "");
                            continue block14;
                        }
                        this.loggedIn = false;
                        this.sendLoginFailedResponse();
                        continue block14;
                    }
                }
                this.sendMultipacketResponse(l, String.format("Unknown request %s", Integer.toHexString(i1)));
            }
            return;
        }
        catch (IOException ioexception) {
            return;
        }
        catch (Exception exception1) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)exception1);
            return;
        }
        finally {
            this.closeSocket();
            LOGGER.info("Thread {} shutting down", (Object)this.threadName);
            this.running = false;
        }
    }

    private void sendResponse(int p_72654_1_, int p_72654_2_, String message) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(1248);
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        byte[] abyte = message.getBytes(StandardCharsets.UTF_8);
        dataoutputstream.writeInt(Integer.reverseBytes(abyte.length + 10));
        dataoutputstream.writeInt(Integer.reverseBytes(p_72654_1_));
        dataoutputstream.writeInt(Integer.reverseBytes(p_72654_2_));
        dataoutputstream.write(abyte);
        dataoutputstream.write(0);
        dataoutputstream.write(0);
        this.clientSocket.getOutputStream().write(bytearrayoutputstream.toByteArray());
    }

    private void sendLoginFailedResponse() throws IOException {
        this.sendResponse(-1, 2, "");
    }

    private void sendMultipacketResponse(int p_72655_1_, String p_72655_2_) throws IOException {
        int j;
        int i = p_72655_2_.length();
        do {
            j = 4096 <= i ? 4096 : i;
            this.sendResponse(p_72655_1_, 0, p_72655_2_.substring(0, j));
        } while (0 != (i = (p_72655_2_ = p_72655_2_.substring(j)).length()));
    }

    @Override
    public void func_219591_b() {
        this.running = false;
        this.closeSocket();
        super.func_219591_b();
    }

    private void closeSocket() {
        try {
            this.clientSocket.close();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to close socket", (Throwable)ioexception);
        }
    }
}

