/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.WorldLightManager;

public class SUpdateLightPacket
implements IPacket<IClientPlayNetHandler> {
    private int chunkX;
    private int chunkZ;
    private int skyLightUpdateMask;
    private int blockLightUpdateMask;
    private int skyLightResetMask;
    private int blockLightResetMask;
    private List<byte[]> skyLightData;
    private List<byte[]> blockLightData;
    private boolean field_241783_i_;

    public SUpdateLightPacket() {
    }

    public SUpdateLightPacket(ChunkPos pos, WorldLightManager lightManager, boolean p_i50774_3_) {
        this.chunkX = pos.x;
        this.chunkZ = pos.z;
        this.field_241783_i_ = p_i50774_3_;
        this.skyLightData = Lists.newArrayList();
        this.blockLightData = Lists.newArrayList();
        for (int i = 0; i < 18; ++i) {
            NibbleArray nibblearray = lightManager.getLightEngine(LightType.SKY).getData(SectionPos.from(pos, -1 + i));
            NibbleArray nibblearray1 = lightManager.getLightEngine(LightType.BLOCK).getData(SectionPos.from(pos, -1 + i));
            if (nibblearray != null) {
                if (nibblearray.isEmpty()) {
                    this.skyLightResetMask |= 1 << i;
                } else {
                    this.skyLightUpdateMask |= 1 << i;
                    this.skyLightData.add((byte[])nibblearray.getData().clone());
                }
            }
            if (nibblearray1 == null) continue;
            if (nibblearray1.isEmpty()) {
                this.blockLightResetMask |= 1 << i;
                continue;
            }
            this.blockLightUpdateMask |= 1 << i;
            this.blockLightData.add((byte[])nibblearray1.getData().clone());
        }
    }

    public SUpdateLightPacket(ChunkPos pos, WorldLightManager lightManager, int skyLightUpdateMaskIn, int blockLightUpdateMaskIn, boolean p_i50775_5_) {
        this.chunkX = pos.x;
        this.chunkZ = pos.z;
        this.field_241783_i_ = p_i50775_5_;
        this.skyLightUpdateMask = skyLightUpdateMaskIn;
        this.blockLightUpdateMask = blockLightUpdateMaskIn;
        this.skyLightData = Lists.newArrayList();
        this.blockLightData = Lists.newArrayList();
        for (int i = 0; i < 18; ++i) {
            if ((this.skyLightUpdateMask & 1 << i) != 0) {
                NibbleArray nibblearray = lightManager.getLightEngine(LightType.SKY).getData(SectionPos.from(pos, -1 + i));
                if (nibblearray != null && !nibblearray.isEmpty()) {
                    this.skyLightData.add((byte[])nibblearray.getData().clone());
                } else {
                    this.skyLightUpdateMask &= ~(1 << i);
                    if (nibblearray != null) {
                        this.skyLightResetMask |= 1 << i;
                    }
                }
            }
            if ((this.blockLightUpdateMask & 1 << i) == 0) continue;
            NibbleArray nibblearray1 = lightManager.getLightEngine(LightType.BLOCK).getData(SectionPos.from(pos, -1 + i));
            if (nibblearray1 != null && !nibblearray1.isEmpty()) {
                this.blockLightData.add((byte[])nibblearray1.getData().clone());
                continue;
            }
            this.blockLightUpdateMask &= ~(1 << i);
            if (nibblearray1 == null) continue;
            this.blockLightResetMask |= 1 << i;
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.chunkX = buf.readVarInt();
        this.chunkZ = buf.readVarInt();
        this.field_241783_i_ = buf.readBoolean();
        this.skyLightUpdateMask = buf.readVarInt();
        this.blockLightUpdateMask = buf.readVarInt();
        this.skyLightResetMask = buf.readVarInt();
        this.blockLightResetMask = buf.readVarInt();
        this.skyLightData = Lists.newArrayList();
        for (int i = 0; i < 18; ++i) {
            if ((this.skyLightUpdateMask & 1 << i) == 0) continue;
            this.skyLightData.add(buf.readByteArray(2048));
        }
        this.blockLightData = Lists.newArrayList();
        for (int j = 0; j < 18; ++j) {
            if ((this.blockLightUpdateMask & 1 << j) == 0) continue;
            this.blockLightData.add(buf.readByteArray(2048));
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.chunkX);
        buf.writeVarInt(this.chunkZ);
        buf.writeBoolean(this.field_241783_i_);
        buf.writeVarInt(this.skyLightUpdateMask);
        buf.writeVarInt(this.blockLightUpdateMask);
        buf.writeVarInt(this.skyLightResetMask);
        buf.writeVarInt(this.blockLightResetMask);
        for (byte[] abyte : this.skyLightData) {
            buf.writeByteArray(abyte);
        }
        for (byte[] abyte1 : this.blockLightData) {
            buf.writeByteArray(abyte1);
        }
    }

    @Override
    public void processPacket(IClientPlayNetHandler handler) {
        handler.handleUpdateLight(this);
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getSkyLightUpdateMask() {
        return this.skyLightUpdateMask;
    }

    public int getSkyLightResetMask() {
        return this.skyLightResetMask;
    }

    public List<byte[]> getSkyLightData() {
        return this.skyLightData;
    }

    public int getBlockLightUpdateMask() {
        return this.blockLightUpdateMask;
    }

    public int getBlockLightResetMask() {
        return this.blockLightResetMask;
    }

    public List<byte[]> getBlockLightData() {
        return this.blockLightData;
    }

    public boolean func_241784_j_() {
        return this.field_241783_i_;
    }
}

