/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.CommandBlockMinecartEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.world.World;

public class CUpdateMinecartCommandBlockPacket
implements IPacket<IServerPlayNetHandler> {
    private int entityId;
    private String command;
    private boolean trackOutput;

    public CUpdateMinecartCommandBlockPacket() {
    }

    public CUpdateMinecartCommandBlockPacket(int entityIdIn, String commandIn, boolean trackOutputIn) {
        this.entityId = entityIdIn;
        this.command = commandIn;
        this.trackOutput = trackOutputIn;
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityId = buf.readVarInt();
        this.command = buf.readString(Short.MAX_VALUE);
        this.trackOutput = buf.readBoolean();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.entityId);
        buf.writeString(this.command);
        buf.writeBoolean(this.trackOutput);
    }

    @Override
    public void processPacket(IServerPlayNetHandler handler) {
        handler.processUpdateCommandMinecart(this);
    }

    @Nullable
    public CommandBlockLogic getCommandBlock(World worldIn) {
        Entity entity = worldIn.getEntityByID(this.entityId);
        return entity instanceof CommandBlockMinecartEntity ? ((CommandBlockMinecartEntity)entity).getCommandBlockLogic() : null;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean shouldTrackOutput() {
        return this.trackOutput;
    }
}

