/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LongNBT
extends NumberNBT {
    public static final INBTType<LongNBT> TYPE = new INBTType<LongNBT>(){

        @Override
        public LongNBT readNBT(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
            accounter.read(128L);
            return LongNBT.valueOf(input.readLong());
        }

        @Override
        public String getName() {
            return "LONG";
        }

        @Override
        public String getTagName() {
            return "TAG_Long";
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }
    };
    private final long data;

    private LongNBT(long data) {
        this.data = data;
    }

    public static LongNBT valueOf(long value) {
        return value >= -128L && value <= 1024L ? Cache.CACHE[(int)value + 128] : new LongNBT(value);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeLong(this.data);
    }

    @Override
    public byte getId() {
        return 4;
    }

    public INBTType<LongNBT> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.data + "L";
    }

    @Override
    public LongNBT copy() {
        return this;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof LongNBT && this.data == ((LongNBT)p_equals_1_).data;
    }

    public int hashCode() {
        return (int)(this.data ^ this.data >>> 32);
    }

    @Override
    public ITextComponent toFormattedComponent(String indentation, int indentDepth) {
        IFormattableTextComponent itextcomponent = new StringTextComponent("L").mergeStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        return new StringTextComponent(String.valueOf(this.data)).append(itextcomponent).mergeStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public int getInt() {
        return (int)(this.data & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public short getShort() {
        return (short)(this.data & 0xFFFFL);
    }

    @Override
    public byte getByte() {
        return (byte)(this.data & 0xFFL);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    static class Cache {
        static final LongNBT[] CACHE = new LongNBT[1153];

        Cache() {
        }

        static {
            for (int i = 0; i < CACHE.length; ++i) {
                Cache.CACHE[i] = new LongNBT(-128 + i);
            }
        }
    }
}

