/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;

public class FireworkStarRecipe
extends SpecialRecipe {
    private static final Ingredient INGREDIENT_SHAPE = Ingredient.fromItems(Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD);
    private static final Ingredient INGREDIENT_FLICKER = Ingredient.fromItems(Items.DIAMOND);
    private static final Ingredient INGREDIENT_TRAIL = Ingredient.fromItems(Items.GLOWSTONE_DUST);
    private static final Map<Item, FireworkRocketItem.Shape> ITEM_SHAPE_MAP = Util.make(Maps.newHashMap(), itemShapeMap -> {
        itemShapeMap.put(Items.FIRE_CHARGE, FireworkRocketItem.Shape.LARGE_BALL);
        itemShapeMap.put(Items.FEATHER, FireworkRocketItem.Shape.BURST);
        itemShapeMap.put(Items.GOLD_NUGGET, FireworkRocketItem.Shape.STAR);
        itemShapeMap.put(Items.SKELETON_SKULL, FireworkRocketItem.Shape.CREEPER);
        itemShapeMap.put(Items.WITHER_SKELETON_SKULL, FireworkRocketItem.Shape.CREEPER);
        itemShapeMap.put(Items.CREEPER_HEAD, FireworkRocketItem.Shape.CREEPER);
        itemShapeMap.put(Items.PLAYER_HEAD, FireworkRocketItem.Shape.CREEPER);
        itemShapeMap.put(Items.DRAGON_HEAD, FireworkRocketItem.Shape.CREEPER);
        itemShapeMap.put(Items.ZOMBIE_HEAD, FireworkRocketItem.Shape.CREEPER);
    });
    private static final Ingredient INGREDIENT_GUNPOWDER = Ingredient.fromItems(Items.GUNPOWDER);

    public FireworkStarRecipe(ResourceLocation id) {
        super(id);
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            if (INGREDIENT_SHAPE.test(itemstack)) {
                if (flag2) {
                    return false;
                }
                flag2 = true;
                continue;
            }
            if (INGREDIENT_TRAIL.test(itemstack)) {
                if (flag4) {
                    return false;
                }
                flag4 = true;
                continue;
            }
            if (INGREDIENT_FLICKER.test(itemstack)) {
                if (flag3) {
                    return false;
                }
                flag3 = true;
                continue;
            }
            if (INGREDIENT_GUNPOWDER.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(itemstack.getItem() instanceof DyeItem)) {
                return false;
            }
            flag1 = true;
        }
        return flag && flag1;
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack itemstack = new ItemStack(Items.FIREWORK_STAR);
        CompoundNBT compoundnbt = itemstack.getOrCreateChildTag("Explosion");
        FireworkRocketItem.Shape fireworkrocketitem$shape = FireworkRocketItem.Shape.SMALL_BALL;
        ArrayList<Integer> list = Lists.newArrayList();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.isEmpty()) continue;
            if (INGREDIENT_SHAPE.test(itemstack1)) {
                fireworkrocketitem$shape = ITEM_SHAPE_MAP.get(itemstack1.getItem());
                continue;
            }
            if (INGREDIENT_TRAIL.test(itemstack1)) {
                compoundnbt.putBoolean("Flicker", true);
                continue;
            }
            if (INGREDIENT_FLICKER.test(itemstack1)) {
                compoundnbt.putBoolean("Trail", true);
                continue;
            }
            if (!(itemstack1.getItem() instanceof DyeItem)) continue;
            list.add(((DyeItem)itemstack1.getItem()).getDyeColor().getFireworkColor());
        }
        compoundnbt.putIntArray("Colors", list);
        compoundnbt.putByte("Type", (byte)fireworkrocketitem$shape.getIndex());
        return itemstack;
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Items.FIREWORK_STAR);
    }

    @Override
    public IRecipeSerializer<?> getSerializer() {
        return IRecipeSerializer.CRAFTING_SPECIAL_FIREWORK_STAR;
    }
}

