/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EyeOfEnderEntity
extends Entity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> field_213864_b = EntityDataManager.createKey(EyeOfEnderEntity.class, DataSerializers.ITEMSTACK);
    private double targetX;
    private double targetY;
    private double targetZ;
    private int despawnTimer;
    private boolean shatterOrDrop;

    public EyeOfEnderEntity(EntityType<? extends EyeOfEnderEntity> p_i50169_1_, World p_i50169_2_) {
        super(p_i50169_1_, p_i50169_2_);
    }

    public EyeOfEnderEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends EyeOfEnderEntity>)EntityType.EYE_OF_ENDER, worldIn);
        this.despawnTimer = 0;
        this.setPosition(x, y, z);
    }

    public void func_213863_b(ItemStack p_213863_1_) {
        if (p_213863_1_.getItem() != Items.ENDER_EYE || p_213863_1_.hasTag()) {
            this.getDataManager().set(field_213864_b, Util.make(p_213863_1_.copy(), p_213862_0_ -> p_213862_0_.setCount(1)));
        }
    }

    private ItemStack func_213861_i() {
        return this.getDataManager().get(field_213864_b);
    }

    @Override
    public ItemStack getItem() {
        ItemStack itemstack = this.func_213861_i();
        return itemstack.isEmpty() ? new ItemStack(Items.ENDER_EYE) : itemstack;
    }

    @Override
    protected void registerData() {
        this.getDataManager().register(field_213864_b, ItemStack.EMPTY);
    }

    @Override
    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.getBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void moveTowards(BlockPos pos) {
        double d3;
        double d0 = pos.getX();
        int i = pos.getY();
        double d1 = pos.getZ();
        double d2 = d0 - this.getPosX();
        float f = MathHelper.sqrt(d2 * d2 + (d3 = d1 - this.getPosZ()) * d3);
        if (f > 12.0f) {
            this.targetX = this.getPosX() + d2 / (double)f * 12.0;
            this.targetZ = this.getPosZ() + d3 / (double)f * 12.0;
            this.targetY = this.getPosY() + 8.0;
        } else {
            this.targetX = d0;
            this.targetY = i;
            this.targetZ = d1;
        }
        this.despawnTimer = 0;
        this.shatterOrDrop = this.rand.nextInt(5) > 0;
    }

    @Override
    public void setVelocity(double x, double y, double z) {
        this.setMotion(x, y, z);
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt(x * x + z * z);
            this.rotationYaw = (float)(MathHelper.atan2(x, z) * 57.2957763671875);
            this.rotationPitch = (float)(MathHelper.atan2(y, f) * 57.2957763671875);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public void tick() {
        super.tick();
        Vector3d vector3d = this.getMotion();
        double d0 = this.getPosX() + vector3d.x;
        double d1 = this.getPosY() + vector3d.y;
        double d2 = this.getPosZ() + vector3d.z;
        float f = MathHelper.sqrt(EyeOfEnderEntity.horizontalMag(vector3d));
        this.rotationPitch = ProjectileEntity.func_234614_e_(this.prevRotationPitch, (float)(MathHelper.atan2(vector3d.y, f) * 57.2957763671875));
        this.rotationYaw = ProjectileEntity.func_234614_e_(this.prevRotationYaw, (float)(MathHelper.atan2(vector3d.x, vector3d.z) * 57.2957763671875));
        if (!this.world.isRemote) {
            double d3 = this.targetX - d0;
            double d4 = this.targetZ - d2;
            float f1 = (float)Math.sqrt(d3 * d3 + d4 * d4);
            float f2 = (float)MathHelper.atan2(d4, d3);
            double d5 = MathHelper.lerp(0.0025, (double)f, (double)f1);
            double d6 = vector3d.y;
            if (f1 < 1.0f) {
                d5 *= 0.8;
                d6 *= 0.8;
            }
            int j = this.getPosY() < this.targetY ? 1 : -1;
            vector3d = new Vector3d(Math.cos(f2) * d5, d6 + ((double)j - d6) * (double)0.015f, Math.sin(f2) * d5);
            this.setMotion(vector3d);
        }
        float f3 = 0.25f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.world.addParticle(ParticleTypes.BUBBLE, d0 - vector3d.x * 0.25, d1 - vector3d.y * 0.25, d2 - vector3d.z * 0.25, vector3d.x, vector3d.y, vector3d.z);
            }
        } else {
            this.world.addParticle(ParticleTypes.PORTAL, d0 - vector3d.x * 0.25 + this.rand.nextDouble() * 0.6 - 0.3, d1 - vector3d.y * 0.25 - 0.5, d2 - vector3d.z * 0.25 + this.rand.nextDouble() * 0.6 - 0.3, vector3d.x, vector3d.y, vector3d.z);
        }
        if (!this.world.isRemote) {
            this.setPosition(d0, d1, d2);
            ++this.despawnTimer;
            if (this.despawnTimer > 80 && !this.world.isRemote) {
                this.playSound(SoundEvents.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
                this.remove();
                if (this.shatterOrDrop) {
                    this.world.addEntity(new ItemEntity(this.world, this.getPosX(), this.getPosY(), this.getPosZ(), this.getItem()));
                } else {
                    this.world.playEvent(2003, this.getPosition(), 0);
                }
            }
        } else {
            this.setRawPosition(d0, d1, d2);
        }
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        ItemStack itemstack = this.func_213861_i();
        if (!itemstack.isEmpty()) {
            compound.put("Item", itemstack.write(new CompoundNBT()));
        }
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        ItemStack itemstack = ItemStack.read(compound.getCompound("Item"));
        this.func_213863_b(itemstack);
    }

    @Override
    public float getBrightness() {
        return 1.0f;
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }

    @Override
    public IPacket<?> createSpawnPacket() {
        return new SSpawnObjectPacket(this);
    }
}

