/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PlayerInventory
implements IInventory,
INameable {
    public final NonNullList<ItemStack> mainInventory = NonNullList.withSize(36, ItemStack.EMPTY);
    public final NonNullList<ItemStack> armorInventory = NonNullList.withSize(4, ItemStack.EMPTY);
    public final NonNullList<ItemStack> offHandInventory = NonNullList.withSize(1, ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories = ImmutableList.of(this.mainInventory, this.armorInventory, this.offHandInventory);
    public int currentItem;
    public final PlayerEntity player;
    private ItemStack itemStack = ItemStack.EMPTY;
    private int timesChanged;

    public PlayerInventory(PlayerEntity playerIn) {
        this.player = playerIn;
    }

    public ItemStack getCurrentItem() {
        return PlayerInventory.isHotbar(this.currentItem) ? this.mainInventory.get(this.currentItem) : ItemStack.EMPTY;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.isEmpty() && this.stackEqualExact(stack1, stack2) && stack1.isStackable() && stack1.getCount() < stack1.getMaxStackSize() && stack1.getCount() < this.getInventoryStackLimit();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && ItemStack.areItemStackTagsEqual(stack1, stack2);
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!this.mainInventory.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void setPickedItemStack(ItemStack stack) {
        int i = this.getSlotFor(stack);
        if (PlayerInventory.isHotbar(i)) {
            this.currentItem = i;
        } else if (i == -1) {
            int j;
            this.currentItem = this.getBestHotbarSlot();
            if (!this.mainInventory.get(this.currentItem).isEmpty() && (j = this.getFirstEmptyStack()) != -1) {
                this.mainInventory.set(j, this.mainInventory.get(this.currentItem));
            }
            this.mainInventory.set(this.currentItem, stack);
        } else {
            this.pickItem(i);
        }
    }

    public void pickItem(int index) {
        this.currentItem = this.getBestHotbarSlot();
        ItemStack itemstack = this.mainInventory.get(this.currentItem);
        this.mainInventory.set(this.currentItem, this.mainInventory.get(index));
        this.mainInventory.set(index, itemstack);
    }

    public static boolean isHotbar(int index) {
        return index >= 0 && index < 9;
    }

    public int getSlotFor(ItemStack stack) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (this.mainInventory.get(i).isEmpty() || !this.stackEqualExact(stack, this.mainInventory.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int findSlotMatchingUnusedItem(ItemStack p_194014_1_) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            ItemStack itemstack = this.mainInventory.get(i);
            if (this.mainInventory.get(i).isEmpty() || !this.stackEqualExact(p_194014_1_, this.mainInventory.get(i)) || this.mainInventory.get(i).isDamaged() || itemstack.isEnchanted() || itemstack.hasDisplayName()) continue;
            return i;
        }
        return -1;
    }

    public int getBestHotbarSlot() {
        for (int i = 0; i < 9; ++i) {
            int j = (this.currentItem + i) % 9;
            if (!this.mainInventory.get(j).isEmpty()) continue;
            return j;
        }
        for (int k = 0; k < 9; ++k) {
            int l = (this.currentItem + k) % 9;
            if (this.mainInventory.get(l).isEnchanted()) continue;
            return l;
        }
        return this.currentItem;
    }

    public void changeCurrentItem(double direction) {
        if (direction > 0.0) {
            direction = 1.0;
        }
        if (direction < 0.0) {
            direction = -1.0;
        }
        this.currentItem = (int)((double)this.currentItem - direction);
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public int func_234564_a_(Predicate<ItemStack> p_234564_1_, int p_234564_2_, IInventory p_234564_3_) {
        int i = 0;
        boolean flag = p_234564_2_ == 0;
        i += ItemStackHelper.func_233534_a_(this, p_234564_1_, p_234564_2_ - i, flag);
        i += ItemStackHelper.func_233534_a_(p_234564_3_, p_234564_1_, p_234564_2_ - i, flag);
        i += ItemStackHelper.func_233535_a_(this.itemStack, p_234564_1_, p_234564_2_ - i, flag);
        if (this.itemStack.isEmpty()) {
            this.itemStack = ItemStack.EMPTY;
        }
        return i;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        int i = this.storeItemStack(itemStackIn);
        if (i == -1) {
            i = this.getFirstEmptyStack();
        }
        return i == -1 ? itemStackIn.getCount() : this.addResource(i, itemStackIn);
    }

    private int addResource(int p_191973_1_, ItemStack p_191973_2_) {
        Item item = p_191973_2_.getItem();
        int i = p_191973_2_.getCount();
        ItemStack itemstack = this.getStackInSlot(p_191973_1_);
        if (itemstack.isEmpty()) {
            itemstack = new ItemStack(item, 0);
            if (p_191973_2_.hasTag()) {
                itemstack.setTag(p_191973_2_.getTag().copy());
            }
            this.setInventorySlotContents(p_191973_1_, itemstack);
        }
        int j = i;
        if (i > itemstack.getMaxStackSize() - itemstack.getCount()) {
            j = itemstack.getMaxStackSize() - itemstack.getCount();
        }
        if (j > this.getInventoryStackLimit() - itemstack.getCount()) {
            j = this.getInventoryStackLimit() - itemstack.getCount();
        }
        if (j == 0) {
            return i;
        }
        itemstack.grow(j);
        itemstack.setAnimationsToGo(5);
        return i -= j;
    }

    public int storeItemStack(ItemStack itemStackIn) {
        if (this.canMergeStacks(this.getStackInSlot(this.currentItem), itemStackIn)) {
            return this.currentItem;
        }
        if (this.canMergeStacks(this.getStackInSlot(40), itemStackIn)) {
            return 40;
        }
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!this.canMergeStacks(this.mainInventory.get(i), itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            for (int i = 0; i < nonnulllist.size(); ++i) {
                if (nonnulllist.get(i).isEmpty()) continue;
                nonnulllist.get(i).inventoryTick(this.player.world, this.player, i, this.currentItem == i);
            }
        }
    }

    public boolean addItemStackToInventory(ItemStack itemStackIn) {
        return this.add(-1, itemStackIn);
    }

    public boolean add(int slotIn, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            int i;
            if (stack.isDamaged()) {
                if (slotIn == -1) {
                    slotIn = this.getFirstEmptyStack();
                }
                if (slotIn >= 0) {
                    this.mainInventory.set(slotIn, stack.copy());
                    this.mainInventory.get(slotIn).setAnimationsToGo(5);
                    stack.setCount(0);
                    return true;
                }
                if (this.player.abilities.isCreativeMode) {
                    stack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.getCount();
                if (slotIn == -1) {
                    stack.setCount(this.storePartialItemStack(stack));
                    continue;
                }
                stack.setCount(this.addResource(slotIn, stack));
            } while (!stack.isEmpty() && stack.getCount() < i);
            if (stack.getCount() == i && this.player.abilities.isCreativeMode) {
                stack.setCount(0);
                return true;
            }
            return stack.getCount() < i;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
            crashreportcategory.addDetail("Item ID", Item.getIdFromItem(stack.getItem()));
            crashreportcategory.addDetail("Item data", stack.getDamage());
            crashreportcategory.addDetail("Item name", () -> stack.getDisplayName().getString());
            throw new ReportedException(crashreport);
        }
    }

    public void placeItemBackInInventory(World worldIn, ItemStack stack) {
        if (!worldIn.isRemote) {
            while (!stack.isEmpty()) {
                int i = this.storeItemStack(stack);
                if (i == -1) {
                    i = this.getFirstEmptyStack();
                }
                if (i == -1) {
                    this.player.dropItem(stack, false);
                    break;
                }
                int j = stack.getMaxStackSize() - this.getStackInSlot(i).getCount();
                if (!this.add(i, stack.split(j))) continue;
                ((ServerPlayerEntity)this.player).connection.sendPacket(new SSetSlotPacket(-2, i, this.getStackInSlot(i)));
            }
        }
    }

    @Override
    public ItemStack decrStackSize(int index, int count) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(index)).isEmpty() ? ItemStackHelper.getAndSplit(list, index, count) : ItemStack.EMPTY;
    }

    public void deleteStack(ItemStack stack) {
        block0: for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            for (int i = 0; i < nonnulllist.size(); ++i) {
                if (nonnulllist.get(i) != stack) continue;
                nonnulllist.set(i, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(index)).isEmpty()) {
            ItemStack itemstack = nonnulllist.get(index);
            nonnulllist.set(index, ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(index, stack);
        }
    }

    public float getDestroySpeed(BlockState state) {
        return this.mainInventory.get(this.currentItem).getDestroySpeed(state);
    }

    public ListNBT write(ListNBT nbtTagListIn) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (this.mainInventory.get(i).isEmpty()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.putByte("Slot", (byte)i);
            this.mainInventory.get(i).write(compoundnbt);
            nbtTagListIn.add(compoundnbt);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (this.armorInventory.get(j).isEmpty()) continue;
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.putByte("Slot", (byte)(j + 100));
            this.armorInventory.get(j).write(compoundnbt1);
            nbtTagListIn.add(compoundnbt1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (this.offHandInventory.get(k).isEmpty()) continue;
            CompoundNBT compoundnbt2 = new CompoundNBT();
            compoundnbt2.putByte("Slot", (byte)(k + 150));
            this.offHandInventory.get(k).write(compoundnbt2);
            nbtTagListIn.add(compoundnbt2);
        }
        return nbtTagListIn;
    }

    public void read(ListNBT nbtTagListIn) {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundNBT compoundnbt = nbtTagListIn.getCompound(i);
            int j = compoundnbt.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.read(compoundnbt);
            if (itemstack.isEmpty()) continue;
            if (j >= 0 && j < this.mainInventory.size()) {
                this.mainInventory.set(j, itemstack);
                continue;
            }
            if (j >= 100 && j < this.armorInventory.size() + 100) {
                this.armorInventory.set(j - 100, itemstack);
                continue;
            }
            if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
            this.offHandInventory.set(j - 150, itemstack);
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.size() + this.armorInventory.size() + this.offHandInventory.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.mainInventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armorInventory) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offHandInventory) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(index);
    }

    @Override
    public ITextComponent getName() {
        return new TranslationTextComponent("container.inventory");
    }

    public ItemStack armorItemInSlot(int slotIn) {
        return this.armorInventory.get(slotIn);
    }

    public void func_234563_a_(DamageSource p_234563_1_, float p_234563_2_) {
        if (!(p_234563_2_ <= 0.0f)) {
            if ((p_234563_2_ /= 4.0f) < 1.0f) {
                p_234563_2_ = 1.0f;
            }
            for (int i = 0; i < this.armorInventory.size(); ++i) {
                ItemStack itemstack = this.armorInventory.get(i);
                if (p_234563_1_.isFireDamage() && itemstack.getItem().isImmuneToFire() || !(itemstack.getItem() instanceof ArmorItem)) continue;
                int j = i;
                itemstack.damageItem((int)p_234563_2_, this.player, p_214023_1_ -> p_214023_1_.sendBreakAnimation(EquipmentSlotType.fromSlotTypeAndIndex(EquipmentSlotType.Group.ARMOR, j)));
            }
        }
    }

    public void dropAllItems() {
        for (List list : this.allInventories) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.isEmpty()) continue;
                this.player.dropItem(itemstack, true, false);
                list.set(i, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void markDirty() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    public void setItemStack(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.player.removed) {
            return false;
        }
        return !(player.getDistanceSq(this.player) > 64.0);
    }

    public boolean hasItemStack(ItemStack itemStackIn) {
        for (List list : this.allInventories) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemstack.isItemEqual(itemStackIn)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTag(ITag<Item> itemTag) {
        for (List list : this.allInventories) {
            for (ItemStack itemstack : list) {
                if (itemstack.isEmpty() || !itemTag.contains(itemstack.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    public void copyInventory(PlayerInventory playerInventory) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setInventorySlotContents(i, playerInventory.getStackInSlot(i));
        }
        this.currentItem = playerInventory.currentItem;
    }

    @Override
    public void clear() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    public void accountStacks(RecipeItemHelper p_201571_1_) {
        for (ItemStack itemstack : this.mainInventory) {
            p_201571_1_.accountPlainStack(itemstack);
        }
    }
}

