/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class SnowGolemEntity
extends GolemEntity
implements IShearable,
IRangedAttackMob {
    private static final DataParameter<Byte> PUMPKIN_EQUIPPED = EntityDataManager.createKey(SnowGolemEntity.class, DataSerializers.BYTE);

    public SnowGolemEntity(EntityType<? extends SnowGolemEntity> type, World worldIn) {
        super((EntityType<? extends GolemEntity>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new RangedAttackGoal(this, 1.25, 20, 10.0f));
        this.goalSelector.addGoal(2, new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.goalSelector.addGoal(4, new LookRandomlyGoal(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<MobEntity>(this, MobEntity.class, 10, true, false, p_213621_0_ -> p_213621_0_ instanceof IMob));
    }

    public static AttributeModifierMap.MutableAttribute func_234226_m_() {
        return MobEntity.func_233666_p_().createMutableAttribute(Attributes.MAX_HEALTH, 4.0).createMutableAttribute(Attributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(PUMPKIN_EQUIPPED, (byte)16);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putBoolean("Pumpkin", this.isPumpkinEquipped());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("Pumpkin")) {
            this.setPumpkinEquipped(compound.getBoolean("Pumpkin"));
        }
    }

    @Override
    public boolean isWaterSensitive() {
        return true;
    }

    @Override
    public void livingTick() {
        super.livingTick();
        if (!this.world.isRemote) {
            int i = MathHelper.floor(this.getPosX());
            int j = MathHelper.floor(this.getPosY());
            int k = MathHelper.floor(this.getPosZ());
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.world.getBiome(blockPos).getTemperature(blockPos2) > 1.0f) {
                this.attackEntityFrom(DamageSource.ON_FIRE, 1.0f);
            }
            if (!this.world.getGameRules().getBoolean(GameRules.MOB_GRIEFING)) {
                return;
            }
            BlockState blockstate = Blocks.SNOW.getDefaultState();
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.floor(this.getPosX() + (double)((float)(l % 2 * 2 - 1) * 0.25f));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(this.getPosY()), k = MathHelper.floor(this.getPosZ() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                if (!this.world.getBlockState(blockpos).isAir() || !(this.world.getBiome(blockpos).getTemperature(blockpos) < 0.8f) || !blockstate.isValidPosition(this.world, blockpos)) continue;
                this.world.setBlockState(blockpos, blockstate);
            }
        }
    }

    @Override
    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        SnowballEntity snowballentity = new SnowballEntity(this.world, this);
        double d0 = target.getPosYEye() - (double)1.1f;
        double d1 = target.getPosX() - this.getPosX();
        double d2 = d0 - snowballentity.getPosY();
        double d3 = target.getPosZ() - this.getPosZ();
        float f = MathHelper.sqrt(d1 * d1 + d3 * d3) * 0.2f;
        snowballentity.shoot(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.playSound(SoundEvents.ENTITY_SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.world.addEntity(snowballentity);
    }

    @Override
    protected float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return 1.7f;
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.getHeldItem(p_230254_2_);
        if (itemstack.getItem() == Items.SHEARS && this.isShearable()) {
            this.shear(SoundCategory.PLAYERS);
            if (!this.world.isRemote) {
                itemstack.damageItem(1, p_230254_1_, p_213622_1_ -> p_213622_1_.sendBreakAnimation(p_230254_2_));
            }
            return ActionResultType.func_233537_a_(this.world.isRemote);
        }
        return ActionResultType.PASS;
    }

    @Override
    public void shear(SoundCategory category) {
        this.world.playMovingSound(null, this, SoundEvents.ENTITY_SNOW_GOLEM_SHEAR, category, 1.0f, 1.0f);
        if (!this.world.isRemote()) {
            this.setPumpkinEquipped(false);
            this.entityDropItem(new ItemStack(Items.CARVED_PUMPKIN), 1.7f);
        }
    }

    @Override
    public boolean isShearable() {
        return this.isAlive() && this.isPumpkinEquipped();
    }

    public boolean isPumpkinEquipped() {
        return (this.dataManager.get(PUMPKIN_EQUIPPED) & 0x10) != 0;
    }

    public void setPumpkinEquipped(boolean pumpkinEquipped) {
        byte b0 = this.dataManager.get(PUMPKIN_EQUIPPED);
        if (pumpkinEquipped) {
            this.dataManager.set(PUMPKIN_EQUIPPED, (byte)(b0 | 0x10));
        } else {
            this.dataManager.set(PUMPKIN_EQUIPPED, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SNOW_GOLEM_DEATH;
    }

    @Override
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.75f * this.getEyeHeight(), this.getWidth() * 0.4f);
    }
}

