/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ArmorStandEntity
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntitySize field_242328_bp = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize field_242329_bq = EntityType.ARMOR_STAND.getSize().scale(0.5f);
    public static final DataParameter<Byte> STATUS = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.BYTE);
    public static final DataParameter<Rotations> HEAD_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> BODY_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_ARM_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_ARM_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_LEG_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_LEG_ROTATION = EntityDataManager.createKey(ArmorStandEntity.class, DataSerializers.ROTATIONS);
    private static final Predicate<Entity> IS_RIDEABLE_MINECART = entity -> entity instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)entity).getMinecartType() == AbstractMinecartEntity.Type.RIDEABLE;
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    private boolean canInteract;
    public long punchCooldown;
    private int disabledSlots;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;

    public ArmorStandEntity(EntityType<? extends ArmorStandEntity> p_i50225_1_, World world) {
        super((EntityType<? extends LivingEntity>)p_i50225_1_, world);
        this.stepHeight = 0.0f;
    }

    public ArmorStandEntity(World worldIn, double posX, double posY, double posZ) {
        this((EntityType<? extends ArmorStandEntity>)EntityType.ARMOR_STAND, worldIn);
        this.setPosition(posX, posY, posZ);
    }

    @Override
    public void recalculateSize() {
        double d0 = this.getPosX();
        double d1 = this.getPosY();
        double d2 = this.getPosZ();
        super.recalculateSize();
        this.setPosition(d0, d1, d2);
    }

    private boolean func_213814_A() {
        return !this.hasMarker() && !this.hasNoGravity();
    }

    @Override
    public boolean isServerWorld() {
        return super.isServerWorld() && this.func_213814_A();
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.dataManager.register(STATUS, (byte)0);
        this.dataManager.register(HEAD_ROTATION, DEFAULT_HEAD_ROTATION);
        this.dataManager.register(BODY_ROTATION, DEFAULT_BODY_ROTATION);
        this.dataManager.register(LEFT_ARM_ROTATION, DEFAULT_LEFTARM_ROTATION);
        this.dataManager.register(RIGHT_ARM_ROTATION, DEFAULT_RIGHTARM_ROTATION);
        this.dataManager.register(LEFT_LEG_ROTATION, DEFAULT_LEFTLEG_ROTATION);
        this.dataManager.register(RIGHT_LEG_ROTATION, DEFAULT_RIGHTLEG_ROTATION);
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return this.armorItems;
    }

    @Override
    public ItemStack getItemStackFromSlot(EquipmentSlotType slotIn) {
        switch (slotIn.getSlotType()) {
            case HAND: {
                return this.handItems.get(slotIn.getIndex());
            }
            case ARMOR: {
                return this.armorItems.get(slotIn.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItemStackToSlot(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn.getSlotType()) {
            case HAND: {
                this.playEquipSound(stack);
                this.handItems.set(slotIn.getIndex(), stack);
                break;
            }
            case ARMOR: {
                this.playEquipSound(stack);
                this.armorItems.set(slotIn.getIndex(), stack);
            }
        }
    }

    @Override
    public boolean replaceItemInInventory(int inventorySlot, ItemStack itemStackIn) {
        EquipmentSlotType equipmentslottype;
        if (inventorySlot == 98) {
            equipmentslottype = EquipmentSlotType.MAINHAND;
        } else if (inventorySlot == 99) {
            equipmentslottype = EquipmentSlotType.OFFHAND;
        } else if (inventorySlot == 100 + EquipmentSlotType.HEAD.getIndex()) {
            equipmentslottype = EquipmentSlotType.HEAD;
        } else if (inventorySlot == 100 + EquipmentSlotType.CHEST.getIndex()) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (inventorySlot == 100 + EquipmentSlotType.LEGS.getIndex()) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else {
            if (inventorySlot != 100 + EquipmentSlotType.FEET.getIndex()) {
                return false;
            }
            equipmentslottype = EquipmentSlotType.FEET;
        }
        if (!itemStackIn.isEmpty() && !MobEntity.isItemStackInSlot(equipmentslottype, itemStackIn) && equipmentslottype != EquipmentSlotType.HEAD) {
            return false;
        }
        this.setItemStackToSlot(equipmentslottype, itemStackIn);
        return true;
    }

    @Override
    public boolean canPickUpItem(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.getSlotForItemStack(itemstackIn);
        return this.getItemStackFromSlot(equipmentslottype).isEmpty() && !this.isDisabled(equipmentslottype);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : this.armorItems) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.isEmpty()) {
                itemstack.write(compoundnbt);
            }
            listnbt.add(compoundnbt);
        }
        compound.put("ArmorItems", listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            if (!itemstack1.isEmpty()) {
                itemstack1.write(compoundnbt1);
            }
            listnbt1.add(compoundnbt1);
        }
        compound.put("HandItems", listnbt1);
        compound.putBoolean("Invisible", this.isInvisible());
        compound.putBoolean("Small", this.isSmall());
        compound.putBoolean("ShowArms", this.getShowArms());
        compound.putInt("DisabledSlots", this.disabledSlots);
        compound.putBoolean("NoBasePlate", this.hasNoBasePlate());
        if (this.hasMarker()) {
            compound.putBoolean("Marker", this.hasMarker());
        }
        compound.put("Pose", this.writePose());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("ArmorItems", 9)) {
            ListNBT listnbt = compound.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, ItemStack.read(listnbt.getCompound(i)));
            }
        }
        if (compound.contains("HandItems", 9)) {
            ListNBT listnbt1 = compound.getList("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, ItemStack.read(listnbt1.getCompound(j)));
            }
        }
        this.setInvisible(compound.getBoolean("Invisible"));
        this.setSmall(compound.getBoolean("Small"));
        this.setShowArms(compound.getBoolean("ShowArms"));
        this.disabledSlots = compound.getInt("DisabledSlots");
        this.setNoBasePlate(compound.getBoolean("NoBasePlate"));
        this.setMarker(compound.getBoolean("Marker"));
        this.noClip = !this.func_213814_A();
        CompoundNBT compoundnbt = compound.getCompound("Pose");
        this.readPose(compoundnbt);
    }

    private void readPose(CompoundNBT tagCompound) {
        ListNBT listnbt = tagCompound.getList("Head", 5);
        this.setHeadRotation(listnbt.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(listnbt));
        ListNBT listnbt1 = tagCompound.getList("Body", 5);
        this.setBodyRotation(listnbt1.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(listnbt1));
        ListNBT listnbt2 = tagCompound.getList("LeftArm", 5);
        this.setLeftArmRotation(listnbt2.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(listnbt2));
        ListNBT listnbt3 = tagCompound.getList("RightArm", 5);
        this.setRightArmRotation(listnbt3.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(listnbt3));
        ListNBT listnbt4 = tagCompound.getList("LeftLeg", 5);
        this.setLeftLegRotation(listnbt4.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(listnbt4));
        ListNBT listnbt5 = tagCompound.getList("RightLeg", 5);
        this.setRightLegRotation(listnbt5.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(listnbt5));
    }

    private CompoundNBT writePose() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (!DEFAULT_HEAD_ROTATION.equals(this.headRotation)) {
            compoundnbt.put("Head", this.headRotation.writeToNBT());
        }
        if (!DEFAULT_BODY_ROTATION.equals(this.bodyRotation)) {
            compoundnbt.put("Body", this.bodyRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals(this.leftArmRotation)) {
            compoundnbt.put("LeftArm", this.leftArmRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals(this.rightArmRotation)) {
            compoundnbt.put("RightArm", this.rightArmRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals(this.leftLegRotation)) {
            compoundnbt.put("LeftLeg", this.leftLegRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals(this.rightLegRotation)) {
            compoundnbt.put("RightLeg", this.rightLegRotation.writeToNBT());
        }
        return compoundnbt;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    protected void collideWithEntity(Entity entityIn) {
    }

    @Override
    protected void collideWithNearbyEntities() {
        List<Entity> list = this.world.getEntitiesInAABBexcluding(this, this.getBoundingBox(), IS_RIDEABLE_MINECART);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.getDistanceSq(entity) <= 0.2)) continue;
            entity.applyEntityCollision(this);
        }
    }

    @Override
    public ActionResultType applyPlayerInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemstack = player.getHeldItem(hand);
        if (!this.hasMarker() && itemstack.getItem() != Items.NAME_TAG) {
            if (player.isSpectator()) {
                return ActionResultType.SUCCESS;
            }
            if (player.world.isRemote) {
                return ActionResultType.CONSUME;
            }
            EquipmentSlotType equipmentslottype = MobEntity.getSlotForItemStack(itemstack);
            if (itemstack.isEmpty()) {
                EquipmentSlotType equipmentslottype2;
                EquipmentSlotType equipmentslottype1 = this.getClickedSlot(vec);
                EquipmentSlotType equipmentSlotType = equipmentslottype2 = this.isDisabled(equipmentslottype1) ? equipmentslottype : equipmentslottype1;
                if (this.hasItemInSlot(equipmentslottype2) && this.equipOrSwap(player, equipmentslottype2, itemstack, hand)) {
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (this.isDisabled(equipmentslottype)) {
                    return ActionResultType.FAIL;
                }
                if (equipmentslottype.getSlotType() == EquipmentSlotType.Group.HAND && !this.getShowArms()) {
                    return ActionResultType.FAIL;
                }
                if (this.equipOrSwap(player, equipmentslottype, itemstack, hand)) {
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlotType getClickedSlot(Vector3d p_190772_1_) {
        EquipmentSlotType equipmentslottype = EquipmentSlotType.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = flag ? p_190772_1_.y * 2.0 : p_190772_1_.y;
        EquipmentSlotType equipmentslottype1 = EquipmentSlotType.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(equipmentslottype1)) {
                return EquipmentSlotType.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlotType.CHEST)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlotType.LEGS)) {
                return EquipmentSlotType.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlotType.HEAD)) {
            return EquipmentSlotType.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlotType.MAINHAND)) return equipmentslottype;
        if (!this.hasItemInSlot(EquipmentSlotType.OFFHAND)) return equipmentslottype;
        return EquipmentSlotType.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlotType slotIn) {
        return (this.disabledSlots & 1 << slotIn.getSlotIndex()) != 0 || slotIn.getSlotType() == EquipmentSlotType.Group.HAND && !this.getShowArms();
    }

    private boolean equipOrSwap(PlayerEntity player, EquipmentSlotType slot, ItemStack stack, Hand hand) {
        ItemStack itemstack = this.getItemStackFromSlot(slot);
        if (!itemstack.isEmpty() && (this.disabledSlots & 1 << slot.getSlotIndex() + 8) != 0) {
            return false;
        }
        if (itemstack.isEmpty() && (this.disabledSlots & 1 << slot.getSlotIndex() + 16) != 0) {
            return false;
        }
        if (player.abilities.isCreativeMode && itemstack.isEmpty() && !stack.isEmpty()) {
            ItemStack itemstack2 = stack.copy();
            itemstack2.setCount(1);
            this.setItemStackToSlot(slot, itemstack2);
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = stack.copy();
            itemstack1.setCount(1);
            this.setItemStackToSlot(slot, itemstack1);
            stack.shrink(1);
            return true;
        }
        this.setItemStackToSlot(slot, stack);
        player.setHeldItem(hand, itemstack);
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.world.isRemote && !this.removed) {
            if (DamageSource.OUT_OF_WORLD.equals(source)) {
                this.remove();
                return false;
            }
            if (!(this.isInvulnerableTo(source) || this.canInteract || this.hasMarker())) {
                if (source.isExplosion()) {
                    this.func_213816_g(source);
                    this.remove();
                    return false;
                }
                if (DamageSource.IN_FIRE.equals(source)) {
                    if (this.isBurning()) {
                        this.damageArmorStand(source, 0.15f);
                    } else {
                        this.setFire(5);
                    }
                    return false;
                }
                if (DamageSource.ON_FIRE.equals(source) && this.getHealth() > 0.5f) {
                    this.damageArmorStand(source, 4.0f);
                    return false;
                }
                boolean flag = source.getImmediateSource() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)source.getImmediateSource()).getPierceLevel() > 0;
                boolean flag2 = "player".equals(source.getDamageType());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.getTrueSource() instanceof PlayerEntity && !((PlayerEntity)source.getTrueSource()).abilities.allowEdit) {
                    return false;
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.remove();
                    return flag1;
                }
                long i = this.world.getGameTime();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.world.setEntityState(this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.breakArmorStand(source);
                    this.playParticles();
                    this.remove();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 32) {
            if (this.world.isRemote) {
                this.world.playSound(this.getPosX(), this.getPosY(), this.getPosZ(), SoundEvents.ENTITY_ARMOR_STAND_HIT, this.getSoundCategory(), 0.3f, 1.0f, false);
                this.punchCooldown = this.world.getGameTime();
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.getBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.world instanceof ServerWorld) {
            ((ServerWorld)this.world).spawnParticle(new BlockParticleData(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.getDefaultState()), this.getPosX(), this.getPosYHeight(0.6666666666666666), this.getPosZ(), 10, this.getWidth() / 4.0f, this.getHeight() / 4.0f, this.getWidth() / 4.0f, 0.05);
        }
    }

    private void damageArmorStand(DamageSource source, float p_213817_2_) {
        float f = this.getHealth();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.func_213816_g(source);
            this.remove();
        } else {
            this.setHealth(f);
        }
    }

    private void breakArmorStand(DamageSource source) {
        Block.spawnAsEntity(this.world, this.getPosition(), new ItemStack(Items.ARMOR_STAND));
        this.func_213816_g(source);
    }

    private void func_213816_g(DamageSource source) {
        this.playBrokenSound();
        this.spawnDrops(source);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = this.handItems.get(i);
            if (itemstack.isEmpty()) continue;
            Block.spawnAsEntity(this.world, this.getPosition().up(), itemstack);
            this.handItems.set(i, ItemStack.EMPTY);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = this.armorItems.get(j);
            if (itemstack1.isEmpty()) continue;
            Block.spawnAsEntity(this.world, this.getPosition().up(), itemstack1);
            this.armorItems.set(j, ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.world.playSound(null, this.getPosX(), this.getPosY(), this.getPosZ(), SoundEvents.ENTITY_ARMOR_STAND_BREAK, this.getSoundCategory(), 1.0f, 1.0f);
    }

    @Override
    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        this.prevRenderYawOffset = this.prevRotationYaw;
        this.renderYawOffset = this.rotationYaw;
        return 0.0f;
    }

    @Override
    protected float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.height * (this.isChild() ? 0.5f : 0.9f);
    }

    @Override
    public double getYOffset() {
        return this.hasMarker() ? 0.0 : (double)0.1f;
    }

    @Override
    public void travel(Vector3d travelVector) {
        if (this.func_213814_A()) {
            super.travel(travelVector);
        }
    }

    @Override
    public void setRenderYawOffset(float offset) {
        this.prevRenderYawOffset = this.prevRotationYaw = offset;
        this.prevRotationYawHead = this.rotationYawHead = offset;
    }

    @Override
    public void setRotationYawHead(float rotation) {
        this.prevRenderYawOffset = this.prevRotationYaw = rotation;
        this.prevRotationYawHead = this.rotationYawHead = rotation;
    }

    @Override
    public void tick() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.tick();
        Rotations rotations = this.dataManager.get(HEAD_ROTATION);
        if (!this.headRotation.equals(rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals(rotations1 = this.dataManager.get(BODY_ROTATION))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals(rotations2 = this.dataManager.get(LEFT_ARM_ROTATION))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals(rotations3 = this.dataManager.get(RIGHT_ARM_ROTATION))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals(rotations4 = this.dataManager.get(LEFT_LEG_ROTATION))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals(rotations5 = this.dataManager.get(RIGHT_LEG_ROTATION))) {
            this.setRightLegRotation(rotations5);
        }
    }

    @Override
    protected void updatePotionMetadata() {
        this.setInvisible(this.canInteract);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.canInteract = invisible;
        super.setInvisible(invisible);
    }

    @Override
    public boolean isChild() {
        return this.isSmall();
    }

    @Override
    public void onKillCommand() {
        this.remove();
    }

    @Override
    public boolean isImmuneToExplosions() {
        return this.isInvisible();
    }

    @Override
    public PushReaction getPushReaction() {
        return this.hasMarker() ? PushReaction.IGNORE : super.getPushReaction();
    }

    private void setSmall(boolean small) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 1, small));
    }

    public boolean isSmall() {
        return (this.dataManager.get(STATUS) & 1) != 0;
    }

    private void setShowArms(boolean showArms) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 4, showArms));
    }

    public boolean getShowArms() {
        return (this.dataManager.get(STATUS) & 4) != 0;
    }

    private void setNoBasePlate(boolean noBasePlate) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 8, noBasePlate));
    }

    public boolean hasNoBasePlate() {
        return (this.dataManager.get(STATUS) & 8) != 0;
    }

    private void setMarker(boolean marker) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 16, marker));
    }

    public boolean hasMarker() {
        return (this.dataManager.get(STATUS) & 0x10) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.dataManager.set(HEAD_ROTATION, vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.dataManager.set(BODY_ROTATION, vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.dataManager.set(LEFT_ARM_ROTATION, vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.dataManager.set(RIGHT_ARM_ROTATION, vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.dataManager.set(LEFT_LEG_ROTATION, vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.dataManager.set(RIGHT_LEG_ROTATION, vec);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    @Override
    public boolean canBeCollidedWith() {
        return super.canBeCollidedWith() && !this.hasMarker();
    }

    @Override
    public boolean hitByEntity(Entity entityIn) {
        return entityIn instanceof PlayerEntity && !this.world.isBlockModifiable((PlayerEntity)entityIn, this.getPosition());
    }

    @Override
    public HandSide getPrimaryHand() {
        return HandSide.RIGHT;
    }

    @Override
    protected SoundEvent getFallSound(int heightIn) {
        return SoundEvents.ENTITY_ARMOR_STAND_FALL;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ARMOR_STAND_BREAK;
    }

    @Override
    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
    }

    @Override
    public boolean canBeHitWithPotion() {
        return false;
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        if (STATUS.equals(key)) {
            this.recalculateSize();
            this.preventEntitySpawning = !this.hasMarker();
        }
        super.notifyDataManagerChange(key);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntitySize getSize(Pose poseIn) {
        return this.func_242330_s(this.hasMarker());
    }

    private EntitySize func_242330_s(boolean p_242330_1_) {
        if (p_242330_1_) {
            return field_242328_bp;
        }
        return this.isChild() ? field_242329_bq : this.getType().getSize();
    }

    @Override
    public Vector3d func_241842_k(float p_241842_1_) {
        if (this.hasMarker()) {
            AxisAlignedBB axisalignedbb = this.func_242330_s(false).func_242286_a(this.getPositionVec());
            BlockPos blockpos = this.getPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.getAllInBoxMutable(new BlockPos(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ), new BlockPos(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ))) {
                int j = Math.max(this.world.getLightFor(LightType.BLOCK, blockpos1), this.world.getLightFor(LightType.SKY, blockpos1));
                if (j == 15) {
                    return Vector3d.copyCentered(blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.toImmutable();
            }
            return Vector3d.copyCentered(blockpos);
        }
        return super.func_241842_k(p_241842_1_);
    }
}

