/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseManager;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderDragonEntity
extends MobEntity
implements IMob {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DataParameter<Integer> PHASE = EntityDataManager.createKey(EnderDragonEntity.class, DataSerializers.VARINT);
    private static final EntityPredicate PLAYER_INVADER_CONDITION = new EntityPredicate().setDistance(64.0);
    public final double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    private final EnderDragonPartEntity[] dragonParts;
    public final EnderDragonPartEntity dragonPartHead;
    private final EnderDragonPartEntity dragonPartNeck;
    private final EnderDragonPartEntity dragonPartBody;
    private final EnderDragonPartEntity dragonPartTail1;
    private final EnderDragonPartEntity dragonPartTail2;
    private final EnderDragonPartEntity dragonPartTail3;
    private final EnderDragonPartEntity dragonPartRightWing;
    private final EnderDragonPartEntity dragonPartLeftWing;
    public float prevAnimTime;
    public float animTime;
    public boolean slowed;
    public int deathTicks;
    public float field_226525_bB_;
    @Nullable
    public EnderCrystalEntity closestEnderCrystal;
    @Nullable
    private final DragonFightManager fightManager;
    private final PhaseManager phaseManager;
    private int growlTime = 100;
    private int sittingDamageReceived;
    private final PathPoint[] pathPoints = new PathPoint[24];
    private final int[] neighbors = new int[24];
    private final PathHeap pathFindQueue = new PathHeap();

    public EnderDragonEntity(EntityType<? extends EnderDragonEntity> type, World worldIn) {
        super((EntityType<? extends MobEntity>)EntityType.ENDER_DRAGON, worldIn);
        this.dragonPartHead = new EnderDragonPartEntity(this, "head", 1.0f, 1.0f);
        this.dragonPartNeck = new EnderDragonPartEntity(this, "neck", 3.0f, 3.0f);
        this.dragonPartBody = new EnderDragonPartEntity(this, "body", 5.0f, 3.0f);
        this.dragonPartTail1 = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail2 = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail3 = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartRightWing = new EnderDragonPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonPartLeftWing = new EnderDragonPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonParts = new EnderDragonPartEntity[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartRightWing, this.dragonPartLeftWing};
        this.setHealth(this.getMaxHealth());
        this.noClip = true;
        this.ignoreFrustumCheck = true;
        this.fightManager = worldIn instanceof ServerWorld ? ((ServerWorld)worldIn).func_241110_C_() : null;
        this.phaseManager = new PhaseManager(this);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().createMutableAttribute(Attributes.MAX_HEALTH, 200.0);
    }

    @Override
    protected void registerData() {
        super.registerData();
        this.getDataManager().register(PHASE, PhaseType.HOVER.getId());
    }

    public double[] getMovementOffsets(int p_70974_1_, float partialTicks) {
        if (this.getShouldBeDead()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = MathHelper.wrapDegrees(this.ringBuffer[j][0] - d0);
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = MathHelper.lerp((double)partialTicks, this.ringBuffer[i][2], this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public void livingTick() {
        if (this.world.isRemote) {
            this.setHealth(this.getHealth());
            if (!this.isSilent()) {
                float f = MathHelper.cos(this.animTime * ((float)Math.PI * 2));
                float f1 = MathHelper.cos(this.prevAnimTime * ((float)Math.PI * 2));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.world.playSound(this.getPosX(), this.getPosY(), this.getPosZ(), SoundEvents.ENTITY_ENDER_DRAGON_FLAP, this.getSoundCategory(), 5.0f, 0.8f + this.rand.nextFloat() * 0.3f, false);
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.growlTime < 0) {
                    this.world.playSound(this.getPosX(), this.getPosY(), this.getPosZ(), SoundEvents.ENTITY_ENDER_DRAGON_GROWL, this.getSoundCategory(), 2.5f, 0.8f + this.rand.nextFloat() * 0.3f, false);
                    this.growlTime = 200 + this.rand.nextInt(200);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.getShouldBeDead()) {
            float f11 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f13 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f14 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.world.addParticle(ParticleTypes.EXPLOSION, this.getPosX() + (double)f11, this.getPosY() + 2.0 + (double)f13, this.getPosZ() + (double)f14, 0.0, 0.0, 0.0);
        } else {
            this.updateDragonEnderCrystal();
            Vector3d vector3d4 = this.getMotion();
            float f12 = 0.2f / (MathHelper.sqrt(EnderDragonEntity.horizontalMag(vector3d4)) * 10.0f + 1.0f);
            this.animTime = this.phaseManager.getCurrentPhase().getIsStationary() ? (this.animTime += 0.1f) : (this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, vector3d4.y))));
            this.rotationYaw = MathHelper.wrapDegrees(this.rotationYaw);
            if (this.isAIDisabled()) {
                this.animTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.rotationYaw;
                        this.ringBuffer[i][1] = this.getPosY();
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.rotationYaw;
                this.ringBuffer[this.ringBufferIndex][1] = this.getPosY();
                if (this.world.isRemote) {
                    if (this.newPosRotationIncrements > 0) {
                        double d7 = this.getPosX() + (this.interpTargetX - this.getPosX()) / (double)this.newPosRotationIncrements;
                        double d0 = this.getPosY() + (this.interpTargetY - this.getPosY()) / (double)this.newPosRotationIncrements;
                        double d1 = this.getPosZ() + (this.interpTargetZ - this.getPosZ()) / (double)this.newPosRotationIncrements;
                        double d2 = MathHelper.wrapDegrees(this.interpTargetYaw - (double)this.rotationYaw);
                        this.rotationYaw = (float)((double)this.rotationYaw + d2 / (double)this.newPosRotationIncrements);
                        this.rotationPitch = (float)((double)this.rotationPitch + (this.interpTargetPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
                        --this.newPosRotationIncrements;
                        this.setPosition(d7, d0, d1);
                        this.setRotation(this.rotationYaw, this.rotationPitch);
                    }
                    this.phaseManager.getCurrentPhase().clientTick();
                } else {
                    Vector3d vector3d;
                    IPhase iphase = this.phaseManager.getCurrentPhase();
                    iphase.serverTick();
                    if (this.phaseManager.getCurrentPhase() != iphase) {
                        iphase = this.phaseManager.getCurrentPhase();
                        iphase.serverTick();
                    }
                    if ((vector3d = iphase.getTargetLocation()) != null) {
                        double d8 = vector3d.x - this.getPosX();
                        double d9 = vector3d.y - this.getPosY();
                        double d10 = vector3d.z - this.getPosZ();
                        double d3 = d8 * d8 + d9 * d9 + d10 * d10;
                        float f6 = iphase.getMaxRiseOrFall();
                        double d4 = MathHelper.sqrt(d8 * d8 + d10 * d10);
                        if (d4 > 0.0) {
                            d9 = MathHelper.clamp(d9 / d4, (double)(-f6), (double)f6);
                        }
                        this.setMotion(this.getMotion().add(0.0, d9 * 0.01, 0.0));
                        this.rotationYaw = MathHelper.wrapDegrees(this.rotationYaw);
                        double d5 = MathHelper.clamp(MathHelper.wrapDegrees(180.0 - MathHelper.atan2(d8, d10) * 57.2957763671875 - (double)this.rotationYaw), -50.0, 50.0);
                        Vector3d vector3d1 = vector3d.subtract(this.getPosX(), this.getPosY(), this.getPosZ()).normalize();
                        Vector3d vector3d2 = new Vector3d(MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180)), this.getMotion().y, -MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180))).normalize();
                        float f8 = Math.max(((float)vector3d2.dotProduct(vector3d1) + 0.5f) / 1.5f, 0.0f);
                        this.field_226525_bB_ *= 0.8f;
                        this.field_226525_bB_ = (float)((double)this.field_226525_bB_ + d5 * (double)iphase.getYawFactor());
                        this.rotationYaw += this.field_226525_bB_ * 0.1f;
                        float f9 = (float)(2.0 / (d3 + 1.0));
                        float f10 = 0.06f;
                        this.moveRelative(0.06f * (f8 * f9 + (1.0f - f9)), new Vector3d(0.0, 0.0, -1.0));
                        if (this.slowed) {
                            this.move(MoverType.SELF, this.getMotion().scale(0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getMotion());
                        }
                        Vector3d vector3d3 = this.getMotion().normalize();
                        double d6 = 0.8 + 0.15 * (vector3d3.dotProduct(vector3d2) + 1.0) / 2.0;
                        this.setMotion(this.getMotion().mul(d6, 0.91f, d6));
                    }
                }
                this.renderYawOffset = this.rotationYaw;
                Vector3d[] avector3d = new Vector3d[this.dragonParts.length];
                for (int j = 0; j < this.dragonParts.length; ++j) {
                    avector3d[j] = new Vector3d(this.dragonParts[j].getPosX(), this.dragonParts[j].getPosY(), this.dragonParts[j].getPosZ());
                }
                float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.cos(f15);
                float f2 = MathHelper.sin(f15);
                float f17 = this.rotationYaw * ((float)Math.PI / 180);
                float f3 = MathHelper.sin(f17);
                float f18 = MathHelper.cos(f17);
                this.setPartPosition(this.dragonPartBody, f3 * 0.5f, 0.0, -f18 * 0.5f);
                this.setPartPosition(this.dragonPartRightWing, f18 * 4.5f, 2.0, f3 * 4.5f);
                this.setPartPosition(this.dragonPartLeftWing, f18 * -4.5f, 2.0, f3 * -4.5f);
                if (!this.world.isRemote && this.hurtTime == 0) {
                    this.collideWithEntities(this.world.getEntitiesInAABBexcluding(this, this.dragonPartRightWing.getBoundingBox().grow(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0), EntityPredicates.CAN_AI_TARGET));
                    this.collideWithEntities(this.world.getEntitiesInAABBexcluding(this, this.dragonPartLeftWing.getBoundingBox().grow(4.0, 2.0, 4.0).offset(0.0, -2.0, 0.0), EntityPredicates.CAN_AI_TARGET));
                    this.attackEntitiesInList(this.world.getEntitiesInAABBexcluding(this, this.dragonPartHead.getBoundingBox().grow(1.0), EntityPredicates.CAN_AI_TARGET));
                    this.attackEntitiesInList(this.world.getEntitiesInAABBexcluding(this, this.dragonPartNeck.getBoundingBox().grow(1.0), EntityPredicates.CAN_AI_TARGET));
                }
                float f4 = MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180) - this.field_226525_bB_ * 0.01f);
                float f19 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180) - this.field_226525_bB_ * 0.01f);
                float f5 = this.getHeadAndNeckYOffset();
                this.setPartPosition(this.dragonPartHead, f4 * 6.5f * f16, f5 + f2 * 6.5f, -f19 * 6.5f * f16);
                this.setPartPosition(this.dragonPartNeck, f4 * 5.5f * f16, f5 + f2 * 5.5f, -f19 * 5.5f * f16);
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    EnderDragonPartEntity enderdragonpartentity = null;
                    if (k == 0) {
                        enderdragonpartentity = this.dragonPartTail1;
                    }
                    if (k == 1) {
                        enderdragonpartentity = this.dragonPartTail2;
                    }
                    if (k == 2) {
                        enderdragonpartentity = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getMovementOffsets(12 + k * 2, 1.0f);
                    float f7 = this.rotationYaw * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f20 = MathHelper.sin(f7);
                    float f21 = MathHelper.cos(f7);
                    float f22 = 1.5f;
                    float f23 = (float)(k + 1) * 2.0f;
                    this.setPartPosition(enderdragonpartentity, -(f3 * 1.5f + f20 * f23) * f16, adouble1[1] - adouble[1] - (double)((f23 + 1.5f) * f2) + 1.5, (f18 * 1.5f + f21 * f23) * f16);
                }
                if (!this.world.isRemote) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.getBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartNeck.getBoundingBox()) | this.destroyBlocksInAABB(this.dragonPartBody.getBoundingBox());
                    if (this.fightManager != null) {
                        this.fightManager.dragonUpdate(this);
                    }
                }
                for (int l = 0; l < this.dragonParts.length; ++l) {
                    this.dragonParts[l].prevPosX = avector3d[l].x;
                    this.dragonParts[l].prevPosY = avector3d[l].y;
                    this.dragonParts[l].prevPosZ = avector3d[l].z;
                    this.dragonParts[l].lastTickPosX = avector3d[l].x;
                    this.dragonParts[l].lastTickPosY = avector3d[l].y;
                    this.dragonParts[l].lastTickPosZ = avector3d[l].z;
                }
            }
        }
    }

    private void setPartPosition(EnderDragonPartEntity part, double offsetX, double offsetY, double offsetZ) {
        part.setPosition(this.getPosX() + offsetX, this.getPosY() + offsetY, this.getPosZ() + offsetZ);
    }

    private float getHeadAndNeckYOffset() {
        if (this.phaseManager.getCurrentPhase().getIsStationary()) {
            return -1.0f;
        }
        double[] adouble = this.getMovementOffsets(5, 1.0f);
        double[] adouble1 = this.getMovementOffsets(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void updateDragonEnderCrystal() {
        if (this.closestEnderCrystal != null) {
            if (this.closestEnderCrystal.removed) {
                this.closestEnderCrystal = null;
            } else if (this.ticksExisted % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.rand.nextInt(10) == 0) {
            List<EnderCrystalEntity> list = this.world.getEntitiesWithinAABB(EnderCrystalEntity.class, this.getBoundingBox().grow(32.0));
            EnderCrystalEntity endercrystalentity = null;
            double d0 = Double.MAX_VALUE;
            for (EnderCrystalEntity endercrystalentity1 : list) {
                double d1 = endercrystalentity1.getDistanceSq(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endercrystalentity = endercrystalentity1;
            }
            this.closestEnderCrystal = endercrystalentity;
        }
    }

    private void collideWithEntities(List<Entity> entities) {
        double d0 = (this.dragonPartBody.getBoundingBox().minX + this.dragonPartBody.getBoundingBox().maxX) / 2.0;
        double d1 = (this.dragonPartBody.getBoundingBox().minZ + this.dragonPartBody.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.getPosX() - d0;
            double d3 = entity.getPosZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.addVelocity(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().getIsStationary() || ((LivingEntity)entity).getRevengeTimer() >= entity.ticksExisted - 2) continue;
            entity.attackEntityFrom(DamageSource.causeMobDamage(this), 5.0f);
            this.applyEnchantments(this, entity);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.attackEntityFrom(DamageSource.causeMobDamage(this), 10.0f);
            this.applyEnchantments(this, entity);
        }
    }

    private float simplifyAngle(double angle) {
        return (float)MathHelper.wrapDegrees(angle);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB area) {
        int i = MathHelper.floor(area.minX);
        int j = MathHelper.floor(area.minY);
        int k = MathHelper.floor(area.minZ);
        int l = MathHelper.floor(area.maxX);
        int i1 = MathHelper.floor(area.maxY);
        int j1 = MathHelper.floor(area.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.world.getBlockState(blockpos);
                    Block block = blockstate.getBlock();
                    if (blockstate.isAir() || blockstate.getMaterial() == Material.FIRE) continue;
                    if (this.world.getGameRules().getBoolean(GameRules.MOB_GRIEFING) && !BlockTags.DRAGON_IMMUNE.contains(block)) {
                        flag1 = this.world.removeBlock(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.rand.nextInt(l - i + 1), j + this.rand.nextInt(i1 - j + 1), k + this.rand.nextInt(j1 - k + 1));
            this.world.playEvent(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean attackEntityPartFrom(EnderDragonPartEntity part, DamageSource source, float damage) {
        if (this.phaseManager.getCurrentPhase().getType() == PhaseType.DYING) {
            return false;
        }
        damage = this.phaseManager.getCurrentPhase().func_221113_a(source, damage);
        if (part != this.dragonPartHead) {
            damage = damage / 4.0f + Math.min(damage, 1.0f);
        }
        if (damage < 0.01f) {
            return false;
        }
        if (source.getTrueSource() instanceof PlayerEntity || source.isExplosion()) {
            float f = this.getHealth();
            this.attackDragonFrom(source, damage);
            if (this.getShouldBeDead() && !this.phaseManager.getCurrentPhase().getIsStationary()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(PhaseType.DYING);
            }
            if (this.phaseManager.getCurrentPhase().getIsStationary()) {
                this.sittingDamageReceived = (int)((float)this.sittingDamageReceived + (f - this.getHealth()));
                if ((float)this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0;
                    this.phaseManager.setPhase(PhaseType.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).getIsThornsDamage()) {
            this.attackEntityPartFrom(this.dragonPartBody, source, amount);
        }
        return false;
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.attackEntityFrom(source, amount);
    }

    @Override
    public void onKillCommand() {
        this.remove();
        if (this.fightManager != null) {
            this.fightManager.dragonUpdate(this);
            this.fightManager.processDragonDeath(this);
        }
    }

    @Override
    protected void onDeathUpdate() {
        if (this.fightManager != null) {
            this.fightManager.dragonUpdate(this);
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 8.0f;
            this.world.addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getPosX() + (double)f, this.getPosY() + 2.0 + (double)f1, this.getPosZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.world.getGameRules().getBoolean(GameRules.DO_MOB_LOOT);
        int i = 500;
        if (this.fightManager != null && !this.fightManager.hasPreviouslyKilledDragon()) {
            i = 12000;
        }
        if (!this.world.isRemote) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.dropExperience(MathHelper.floor((float)i * 0.08f));
            }
            if (this.deathTicks == 1 && !this.isSilent()) {
                this.world.playBroadcastSound(1028, this.getPosition(), 0);
            }
        }
        this.move(MoverType.SELF, new Vector3d(0.0, 0.1f, 0.0));
        this.rotationYaw += 20.0f;
        this.renderYawOffset = this.rotationYaw;
        if (this.deathTicks == 200 && !this.world.isRemote) {
            if (flag) {
                this.dropExperience(MathHelper.floor((float)i * 0.2f));
            }
            if (this.fightManager != null) {
                this.fightManager.processDragonDeath(this);
            }
            this.remove();
        }
    }

    private void dropExperience(int xp) {
        while (xp > 0) {
            int i = ExperienceOrbEntity.getXPSplit(xp);
            xp -= i;
            this.world.addEntity(new ExperienceOrbEntity(this.world, this.getPosX(), this.getPosY(), this.getPosZ(), i));
        }
    }

    public int initPathPoints() {
        if (this.pathPoints[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = MathHelper.floor(60.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                    i1 = MathHelper.floor(60.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                } else if (i < 20) {
                    int lvt_3_1_ = i - 12;
                    l = MathHelper.floor(40.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)));
                    i1 = MathHelper.floor(40.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = MathHelper.floor(20.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                    i1 = MathHelper.floor(20.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                }
                int j1 = Math.max(this.world.getSeaLevel() + 10, this.world.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).getY() + j);
                this.pathPoints[i] = new PathPoint(l, j1, i1);
            }
            this.neighbors[0] = 6146;
            this.neighbors[1] = 8197;
            this.neighbors[2] = 8202;
            this.neighbors[3] = 16404;
            this.neighbors[4] = 32808;
            this.neighbors[5] = 32848;
            this.neighbors[6] = 65696;
            this.neighbors[7] = 131392;
            this.neighbors[8] = 131712;
            this.neighbors[9] = 263424;
            this.neighbors[10] = 526848;
            this.neighbors[11] = 525313;
            this.neighbors[12] = 1581057;
            this.neighbors[13] = 3166214;
            this.neighbors[14] = 2138120;
            this.neighbors[15] = 6373424;
            this.neighbors[16] = 4358208;
            this.neighbors[17] = 12910976;
            this.neighbors[18] = 9044480;
            this.neighbors[19] = 9706496;
            this.neighbors[20] = 15216640;
            this.neighbors[21] = 0xD0E000;
            this.neighbors[22] = 11763712;
            this.neighbors[23] = 0x7E0000;
        }
        return this.getNearestPpIdx(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public int getNearestPpIdx(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
        int j = 0;
        if (this.fightManager == null || this.fightManager.getNumAliveCrystals() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].distanceToSquared(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int startIdx, int finishIdx, @Nullable PathPoint andThen) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.pathPoints[i];
            pathpoint.visited = false;
            pathpoint.distanceToTarget = 0.0f;
            pathpoint.totalPathDistance = 0.0f;
            pathpoint.distanceToNext = 0.0f;
            pathpoint.previous = null;
            pathpoint.index = -1;
        }
        PathPoint pathpoint4 = this.pathPoints[startIdx];
        PathPoint pathpoint5 = this.pathPoints[finishIdx];
        pathpoint4.totalPathDistance = 0.0f;
        pathpoint4.distanceToTarget = pathpoint4.distanceToNext = pathpoint4.distanceTo(pathpoint5);
        this.pathFindQueue.clearPath();
        this.pathFindQueue.addPoint(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 0;
        if (this.fightManager == null || this.fightManager.getNumAliveCrystals() == 0) {
            j = 12;
        }
        while (!this.pathFindQueue.isPathEmpty()) {
            PathPoint pathpoint2 = this.pathFindQueue.dequeue();
            if (pathpoint2.equals(pathpoint5)) {
                if (andThen != null) {
                    andThen.previous = pathpoint5;
                    pathpoint5 = andThen;
                }
                return this.makePath(pathpoint4, pathpoint5);
            }
            if (pathpoint2.distanceTo(pathpoint5) < pathpoint1.distanceTo(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.visited = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.pathPoints[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.neighbors[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.pathPoints[i1];
                if (pathpoint3.visited) continue;
                float f = pathpoint2.totalPathDistance + pathpoint2.distanceTo(pathpoint3);
                if (pathpoint3.isAssigned() && !(f < pathpoint3.totalPathDistance)) continue;
                pathpoint3.previous = pathpoint2;
                pathpoint3.totalPathDistance = f;
                pathpoint3.distanceToNext = pathpoint3.distanceTo(pathpoint5);
                if (pathpoint3.isAssigned()) {
                    this.pathFindQueue.changeDistance(pathpoint3, pathpoint3.totalPathDistance + pathpoint3.distanceToNext);
                    continue;
                }
                pathpoint3.distanceToTarget = pathpoint3.totalPathDistance + pathpoint3.distanceToNext;
                this.pathFindQueue.addPoint(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)startIdx, (Object)finishIdx);
        if (andThen != null) {
            andThen.previous = pathpoint1;
            pathpoint1 = andThen;
        }
        return this.makePath(pathpoint4, pathpoint1);
    }

    private Path makePath(PathPoint start, PathPoint finish) {
        ArrayList<PathPoint> list = Lists.newArrayList();
        PathPoint pathpoint = finish;
        list.add(0, finish);
        while (pathpoint.previous != null) {
            pathpoint = pathpoint.previous;
            list.add(0, pathpoint);
        }
        return new Path(list, new BlockPos(finish.x, finish.y, finish.z), true);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        compound.putInt("DragonPhase", this.phaseManager.getCurrentPhase().getType().getId());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("DragonPhase")) {
            this.phaseManager.setPhase(PhaseType.getById(compound.getInt("DragonPhase")));
        }
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPartEntity[] getDragonParts() {
        return this.dragonParts;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public SoundCategory getSoundCategory() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int p_184667_1_, double[] spineEndOffsets, double[] headPartOffsets) {
        double d0;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        if (phasetype != PhaseType.LANDING && phasetype != PhaseType.TAKEOFF) {
            d0 = iphase.getIsStationary() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : headPartOffsets[1] - spineEndOffsets[1]);
        } else {
            BlockPos blockpos = this.world.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.END_PODIUM_LOCATION);
            float f = Math.max(MathHelper.sqrt(blockpos.distanceSq(this.getPositionVec(), true)) / 4.0f, 1.0f);
            d0 = (float)p_184667_1_ / f;
        }
        return (float)d0;
    }

    public Vector3d getHeadLookVec(float partialTicks) {
        Vector3d vector3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        if (phasetype != PhaseType.LANDING && phasetype != PhaseType.TAKEOFF) {
            if (iphase.getIsStationary()) {
                float f4 = this.rotationPitch;
                float f5 = 1.5f;
                this.rotationPitch = -45.0f;
                vector3d = this.getLook(partialTicks);
                this.rotationPitch = f4;
            } else {
                vector3d = this.getLook(partialTicks);
            }
        } else {
            BlockPos blockpos = this.world.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.END_PODIUM_LOCATION);
            float f = Math.max(MathHelper.sqrt(blockpos.distanceSq(this.getPositionVec(), true)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.rotationPitch;
            float f3 = 1.5f;
            this.rotationPitch = -f1 * 1.5f * 5.0f;
            vector3d = this.getLook(partialTicks);
            this.rotationPitch = f2;
        }
        return vector3d;
    }

    public void onCrystalDestroyed(EnderCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc) {
        PlayerEntity playerentity = dmgSrc.getTrueSource() instanceof PlayerEntity ? (PlayerEntity)dmgSrc.getTrueSource() : this.world.getClosestPlayer(PLAYER_INVADER_CONDITION, pos.getX(), pos.getY(), pos.getZ());
        if (crystal == this.closestEnderCrystal) {
            this.attackEntityPartFrom(this.dragonPartHead, DamageSource.causeExplosionDamage(playerentity), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(crystal, pos, dmgSrc, playerentity);
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> key) {
        if (PHASE.equals(key) && this.world.isRemote) {
            this.phaseManager.setPhase(PhaseType.getById(this.getDataManager().get(PHASE)));
        }
        super.notifyDataManagerChange(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public DragonFightManager getFightManager() {
        return this.fightManager;
    }

    @Override
    public boolean addPotionEffect(EffectInstance effectInstanceIn) {
        return false;
    }

    @Override
    protected boolean canBeRidden(Entity entityIn) {
        return false;
    }

    @Override
    public boolean isNonBoss() {
        return false;
    }
}

