/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.goal;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.server.ServerWorld;

public class TriggerSkeletonTrapGoal
extends Goal {
    private final SkeletonHorseEntity horse;

    public TriggerSkeletonTrapGoal(SkeletonHorseEntity horseIn) {
        this.horse = horseIn;
    }

    @Override
    public boolean shouldExecute() {
        return this.horse.world.isPlayerWithin(this.horse.getPosX(), this.horse.getPosY(), this.horse.getPosZ(), 10.0);
    }

    @Override
    public void tick() {
        ServerWorld serverworld = (ServerWorld)this.horse.world;
        DifficultyInstance difficultyinstance = serverworld.getDifficultyForLocation(this.horse.getPosition());
        this.horse.setTrap(false);
        this.horse.setHorseTamed(true);
        this.horse.setGrowingAge(0);
        LightningBoltEntity lightningboltentity = EntityType.LIGHTNING_BOLT.create(serverworld);
        lightningboltentity.moveForced(this.horse.getPosX(), this.horse.getPosY(), this.horse.getPosZ());
        lightningboltentity.setEffectOnly(true);
        serverworld.addEntity(lightningboltentity);
        SkeletonEntity skeletonentity = this.createSkeleton(difficultyinstance, this.horse);
        skeletonentity.startRiding(this.horse);
        serverworld.func_242417_l(skeletonentity);
        for (int i = 0; i < 3; ++i) {
            AbstractHorseEntity abstracthorseentity = this.createHorse(difficultyinstance);
            SkeletonEntity skeletonentity1 = this.createSkeleton(difficultyinstance, abstracthorseentity);
            skeletonentity1.startRiding(abstracthorseentity);
            abstracthorseentity.addVelocity(this.horse.getRNG().nextGaussian() * 0.5, 0.0, this.horse.getRNG().nextGaussian() * 0.5);
            serverworld.func_242417_l(abstracthorseentity);
        }
    }

    private AbstractHorseEntity createHorse(DifficultyInstance p_188515_1_) {
        SkeletonHorseEntity skeletonhorseentity = EntityType.SKELETON_HORSE.create(this.horse.world);
        skeletonhorseentity.onInitialSpawn((ServerWorld)this.horse.world, p_188515_1_, SpawnReason.TRIGGERED, null, null);
        skeletonhorseentity.setPosition(this.horse.getPosX(), this.horse.getPosY(), this.horse.getPosZ());
        skeletonhorseentity.hurtResistantTime = 60;
        skeletonhorseentity.enablePersistence();
        skeletonhorseentity.setHorseTamed(true);
        skeletonhorseentity.setGrowingAge(0);
        return skeletonhorseentity;
    }

    private SkeletonEntity createSkeleton(DifficultyInstance p_188514_1_, AbstractHorseEntity horse) {
        SkeletonEntity skeletonentity = EntityType.SKELETON.create(horse.world);
        skeletonentity.onInitialSpawn((ServerWorld)horse.world, p_188514_1_, SpawnReason.TRIGGERED, null, null);
        skeletonentity.setPosition(horse.getPosX(), horse.getPosY(), horse.getPosZ());
        skeletonentity.hurtResistantTime = 60;
        skeletonentity.enablePersistence();
        if (skeletonentity.getItemStackFromSlot(EquipmentSlotType.HEAD).isEmpty()) {
            skeletonentity.setItemStackToSlot(EquipmentSlotType.HEAD, new ItemStack(Items.IRON_HELMET));
        }
        skeletonentity.setItemStackToSlot(EquipmentSlotType.MAINHAND, EnchantmentHelper.addRandomEnchantment(skeletonentity.getRNG(), this.func_242327_a(skeletonentity.getHeldItemMainhand()), (int)(5.0f + p_188514_1_.getClampedAdditionalDifficulty() * (float)skeletonentity.getRNG().nextInt(18)), false));
        skeletonentity.setItemStackToSlot(EquipmentSlotType.HEAD, EnchantmentHelper.addRandomEnchantment(skeletonentity.getRNG(), this.func_242327_a(skeletonentity.getItemStackFromSlot(EquipmentSlotType.HEAD)), (int)(5.0f + p_188514_1_.getClampedAdditionalDifficulty() * (float)skeletonentity.getRNG().nextInt(18)), false));
        return skeletonentity;
    }

    private ItemStack func_242327_a(ItemStack p_242327_1_) {
        p_242327_1_.removeChildTag("Enchantments");
        return p_242327_1_;
    }
}

