/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.world.server.ServerWorld;

public class PanicTask
extends Task<VillagerEntity> {
    public PanicTask() {
        super(ImmutableMap.of());
    }

    @Override
    protected boolean shouldContinueExecuting(ServerWorld worldIn, VillagerEntity entityIn, long gameTimeIn) {
        return PanicTask.hasBeenHurt(entityIn) || PanicTask.hostileNearby(entityIn);
    }

    @Override
    protected void startExecuting(ServerWorld worldIn, VillagerEntity entityIn, long gameTimeIn) {
        if (PanicTask.hasBeenHurt(entityIn) || PanicTask.hostileNearby(entityIn)) {
            Brain<VillagerEntity> brain = entityIn.getBrain();
            if (!brain.hasActivity(Activity.PANIC)) {
                brain.removeMemory(MemoryModuleType.PATH);
                brain.removeMemory(MemoryModuleType.WALK_TARGET);
                brain.removeMemory(MemoryModuleType.LOOK_TARGET);
                brain.removeMemory(MemoryModuleType.BREED_TARGET);
                brain.removeMemory(MemoryModuleType.INTERACTION_TARGET);
            }
            brain.switchTo(Activity.PANIC);
        }
    }

    @Override
    protected void updateTask(ServerWorld worldIn, VillagerEntity owner, long gameTime) {
        if (gameTime % 100L == 0L) {
            owner.func_242367_a(worldIn, gameTime, 3);
        }
    }

    public static boolean hostileNearby(LivingEntity entity) {
        return entity.getBrain().hasMemory(MemoryModuleType.NEAREST_HOSTILE);
    }

    public static boolean hasBeenHurt(LivingEntity entity) {
        return entity.getBrain().hasMemory(MemoryModuleType.HURT_BY);
    }
}

