/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class InteractWithEntityTask<E extends LivingEntity, T extends LivingEntity>
extends Task<E> {
    private final int field_220446_a;
    private final float field_220447_b;
    private final EntityType<? extends T> field_220448_c;
    private final int field_220449_d;
    private final Predicate<T> field_220450_e;
    private final Predicate<E> field_220451_f;
    private final MemoryModuleType<T> field_220452_g;

    public InteractWithEntityTask(EntityType<? extends T> p_i50363_1_, int p_i50363_2_, Predicate<E> p_i50363_3_, Predicate<T> p_i50363_4_, MemoryModuleType<T> p_i50363_5_, float p_i50363_6_, int p_i50363_7_) {
        super(ImmutableMap.of(MemoryModuleType.LOOK_TARGET, MemoryModuleStatus.REGISTERED, MemoryModuleType.WALK_TARGET, MemoryModuleStatus.VALUE_ABSENT, MemoryModuleType.VISIBLE_MOBS, MemoryModuleStatus.VALUE_PRESENT));
        this.field_220448_c = p_i50363_1_;
        this.field_220447_b = p_i50363_6_;
        this.field_220449_d = p_i50363_2_ * p_i50363_2_;
        this.field_220446_a = p_i50363_7_;
        this.field_220450_e = p_i50363_4_;
        this.field_220451_f = p_i50363_3_;
        this.field_220452_g = p_i50363_5_;
    }

    public static <T extends LivingEntity> InteractWithEntityTask<LivingEntity, T> func_220445_a(EntityType<? extends T> p_220445_0_, int p_220445_1_, MemoryModuleType<T> p_220445_2_, float p_220445_3_, int p_220445_4_) {
        return new InteractWithEntityTask<LivingEntity, LivingEntity>(p_220445_0_, p_220445_1_, p_220441_0_ -> true, p_220442_0_ -> true, p_220445_2_, p_220445_3_, p_220445_4_);
    }

    @Override
    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        return this.field_220451_f.test(owner) && this.func_233913_a_(owner);
    }

    private boolean func_233913_a_(E p_233913_1_) {
        List<LivingEntity> list = ((LivingEntity)p_233913_1_).getBrain().getMemory(MemoryModuleType.VISIBLE_MOBS).get();
        return list.stream().anyMatch(this::func_233914_b_);
    }

    private boolean func_233914_b_(LivingEntity p_233914_1_) {
        return this.field_220448_c.equals(p_233914_1_.getType()) && this.field_220450_e.test(p_233914_1_);
    }

    @Override
    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        Brain<?> brain = ((LivingEntity)entityIn).getBrain();
        brain.getMemory(MemoryModuleType.VISIBLE_MOBS).ifPresent(p_220437_3_ -> p_220437_3_.stream().filter(p_220440_1_ -> this.field_220448_c.equals(p_220440_1_.getType())).map(p_220439_0_ -> p_220439_0_).filter(p_220443_2_ -> p_220443_2_.getDistanceSq((Entity)entityIn) <= (double)this.field_220449_d).filter(this.field_220450_e).findFirst().ifPresent(p_220438_2_ -> {
            brain.setMemory(this.field_220452_g, p_220438_2_);
            brain.setMemory(MemoryModuleType.LOOK_TARGET, new EntityPosWrapper((Entity)p_220438_2_, true));
            brain.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityPosWrapper((Entity)p_220438_2_, false), this.field_220447_b, this.field_220446_a));
        }));
    }
}

