/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class CreatureEntity
extends MobEntity {
    protected CreatureEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super((EntityType<? extends MobEntity>)type, worldIn);
    }

    public float getBlockPathWeight(BlockPos pos) {
        return this.getBlockPathWeight(pos, this.world);
    }

    public float getBlockPathWeight(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    @Override
    public boolean canSpawn(IWorld worldIn, SpawnReason spawnReasonIn) {
        return this.getBlockPathWeight(this.getPosition(), worldIn) >= 0.0f;
    }

    public boolean hasPath() {
        return !this.getNavigator().noPath();
    }

    @Override
    protected void updateLeashedState() {
        super.updateLeashedState();
        Entity entity = this.getLeashHolder();
        if (entity != null && entity.world == this.world) {
            this.setHomePosAndDistance(entity.getPosition(), 5);
            float f = this.getDistance(entity);
            if (this instanceof TameableEntity && ((TameableEntity)this).isSleeping()) {
                if (f > 10.0f) {
                    this.clearLeashed(true, true);
                }
                return;
            }
            this.onLeashDistance(f);
            if (f > 10.0f) {
                this.clearLeashed(true, true);
                this.goalSelector.disableFlag(Goal.Flag.MOVE);
            } else if (f > 6.0f) {
                double d0 = (entity.getPosX() - this.getPosX()) / (double)f;
                double d1 = (entity.getPosY() - this.getPosY()) / (double)f;
                double d2 = (entity.getPosZ() - this.getPosZ()) / (double)f;
                this.setMotion(this.getMotion().add(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
            } else {
                this.goalSelector.enableFlag(Goal.Flag.MOVE);
                float f1 = 2.0f;
                Vector3d vector3d = new Vector3d(entity.getPosX() - this.getPosX(), entity.getPosY() - this.getPosY(), entity.getPosZ() - this.getPosZ()).normalize().scale(Math.max(f - 2.0f, 0.0f));
                this.getNavigator().tryMoveToXYZ(this.getPosX() + vector3d.x, this.getPosY() + vector3d.y, this.getPosZ() + vector3d.z, this.followLeashSpeed());
            }
        }
    }

    protected double followLeashSpeed() {
        return 1.0;
    }

    protected void onLeashDistance(float distance) {
    }
}

