/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DirectoryCache;

public interface IDataProvider {
    public static final HashFunction HASH_FUNCTION = Hashing.sha1();

    public void act(DirectoryCache var1) throws IOException;

    public String getName();

    public static void save(Gson gson, DirectoryCache cache, JsonElement jsonElement, Path pathIn) throws IOException {
        String s = gson.toJson(jsonElement);
        String s1 = HASH_FUNCTION.hashUnencodedChars(s).toString();
        if (!Objects.equals(cache.getPreviousHash(pathIn), s1) || !Files.exists(pathIn, new LinkOption[0])) {
            Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                bufferedwriter.write(s);
            }
        }
        cache.recordHash(pathIn, s1);
    }
}

