/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.inventory.IClearable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType(new TranslationTextComponent("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(p_198688_0_ -> p_198688_0_.hasPermissionLevel(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.blockState()).executes(p_198682_0_ -> SetBlockCommand.setBlock((CommandSource)p_198682_0_.getSource(), BlockPosArgument.getLoadedBlockPos(p_198682_0_, "pos"), BlockStateArgument.getBlockState(p_198682_0_, "block"), Mode.REPLACE, null))).then(Commands.literal("destroy").executes(p_198685_0_ -> SetBlockCommand.setBlock((CommandSource)p_198685_0_.getSource(), BlockPosArgument.getLoadedBlockPos(p_198685_0_, "pos"), BlockStateArgument.getBlockState(p_198685_0_, "block"), Mode.DESTROY, null)))).then(Commands.literal("keep").executes(p_198681_0_ -> SetBlockCommand.setBlock((CommandSource)p_198681_0_.getSource(), BlockPosArgument.getLoadedBlockPos(p_198681_0_, "pos"), BlockStateArgument.getBlockState(p_198681_0_, "block"), Mode.REPLACE, p_198687_0_ -> p_198687_0_.getWorld().isAirBlock(p_198687_0_.getPos()))))).then(Commands.literal("replace").executes(p_198686_0_ -> SetBlockCommand.setBlock((CommandSource)p_198686_0_.getSource(), BlockPosArgument.getLoadedBlockPos(p_198686_0_, "pos"), BlockStateArgument.getBlockState(p_198686_0_, "block"), Mode.REPLACE, null))))));
    }

    private static int setBlock(CommandSource source, BlockPos pos, BlockStateInput state, Mode mode, @Nullable Predicate<CachedBlockInfo> predicate) throws CommandSyntaxException {
        boolean flag;
        ServerWorld serverworld = source.getWorld();
        if (predicate != null && !predicate.test(new CachedBlockInfo(serverworld, pos, true))) {
            throw FAILED_EXCEPTION.create();
        }
        if (mode == Mode.DESTROY) {
            serverworld.destroyBlock(pos, true);
            flag = !state.getState().isAir() || !serverworld.getBlockState(pos).isAir();
        } else {
            TileEntity tileentity = serverworld.getTileEntity(pos);
            IClearable.clearObj(tileentity);
            flag = true;
        }
        if (flag && !state.place(serverworld, pos, 2)) {
            throw FAILED_EXCEPTION.create();
        }
        serverworld.func_230547_a_(pos, state.getState().getBlock());
        source.sendFeedback(new TranslationTextComponent("commands.setblock.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }

    public static interface IFilter {
        @Nullable
        public BlockStateInput filter(MutableBoundingBox var1, BlockPos var2, BlockStateInput var3, ServerWorld var4);
    }
}

