/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments.serializers;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.serializers.BrigadierSerializers;
import net.minecraft.network.PacketBuffer;

public class FloatArgumentSerializer
implements IArgumentSerializer<FloatArgumentType> {
    @Override
    public void write(FloatArgumentType argument, PacketBuffer buffer) {
        boolean flag = argument.getMinimum() != -3.4028235E38f;
        boolean flag1 = argument.getMaximum() != Float.MAX_VALUE;
        buffer.writeByte(BrigadierSerializers.minMaxFlags(flag, flag1));
        if (flag) {
            buffer.writeFloat(argument.getMinimum());
        }
        if (flag1) {
            buffer.writeFloat(argument.getMaximum());
        }
    }

    @Override
    public FloatArgumentType read(PacketBuffer buffer) {
        byte b0 = buffer.readByte();
        float f = BrigadierSerializers.hasMin(b0) ? buffer.readFloat() : -3.4028235E38f;
        float f1 = BrigadierSerializers.hasMax(b0) ? buffer.readFloat() : Float.MAX_VALUE;
        return FloatArgumentType.floatArg(f, f1);
    }

    @Override
    public void write(FloatArgumentType p_212244_1_, JsonObject p_212244_2_) {
        if (p_212244_1_.getMinimum() != -3.4028235E38f) {
            p_212244_2_.addProperty("min", Float.valueOf(p_212244_1_.getMinimum()));
        }
        if (p_212244_1_.getMaximum() != Float.MAX_VALUE) {
            p_212244_2_.addProperty("max", Float.valueOf(p_212244_1_.getMaximum()));
        }
    }
}

