/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockPredicateArgument
implements ArgumentType<IResult> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(p_208682_0_ -> new TranslationTextComponent("arguments.block.tag.unknown", p_208682_0_));

    public static BlockPredicateArgument blockPredicate() {
        return new BlockPredicateArgument();
    }

    @Override
    public IResult parse(StringReader p_parse_1_) throws CommandSyntaxException {
        BlockStateParser blockstateparser = new BlockStateParser(p_parse_1_, true).parse(true);
        if (blockstateparser.getState() != null) {
            BlockPredicate blockpredicateargument$blockpredicate = new BlockPredicate(blockstateparser.getState(), blockstateparser.getProperties().keySet(), blockstateparser.getNbt());
            return p_199823_1_ -> blockpredicateargument$blockpredicate;
        }
        ResourceLocation resourcelocation = blockstateparser.getTag();
        return p_199822_2_ -> {
            ITag<Block> itag = p_199822_2_.getBlockTags().get(resourcelocation);
            if (itag == null) {
                throw UNKNOWN_TAG.create(resourcelocation.toString());
            }
            return new TagPredicate(itag, blockstateparser.getStringProperties(), blockstateparser.getNbt());
        };
    }

    public static Predicate<CachedBlockInfo> getBlockPredicate(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return context.getArgument(name, IResult.class).create(context.getSource().getServer().func_244266_aF());
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        StringReader stringreader = new StringReader(p_listSuggestions_2_.getInput());
        stringreader.setCursor(p_listSuggestions_2_.getStart());
        BlockStateParser blockstateparser = new BlockStateParser(stringreader, true);
        try {
            blockstateparser.parse(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return blockstateparser.getSuggestions(p_listSuggestions_2_, BlockTags.getCollection());
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static class TagPredicate
    implements Predicate<CachedBlockInfo> {
        private final ITag<Block> tag;
        @Nullable
        private final CompoundNBT nbt;
        private final Map<String, String> properties;

        private TagPredicate(ITag<Block> tagIn, Map<String, String> propertiesIn, @Nullable CompoundNBT nbtIn) {
            this.tag = tagIn;
            this.properties = propertiesIn;
            this.nbt = nbtIn;
        }

        @Override
        public boolean test(CachedBlockInfo p_test_1_) {
            BlockState blockstate = p_test_1_.getBlockState();
            if (!blockstate.isIn(this.tag)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                Property<?> property = blockstate.getBlock().getStateContainer().getProperty(entry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable comparable = property.parseValue(entry.getValue()).orElse(null);
                if (comparable == null) {
                    return false;
                }
                if (blockstate.get(property) == comparable) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            TileEntity tileentity = p_test_1_.getTileEntity();
            return tileentity != null && NBTUtil.areNBTEquals(this.nbt, tileentity.write(new CompoundNBT()), true);
        }
    }

    public static interface IResult {
        public Predicate<CachedBlockInfo> create(ITagCollectionSupplier var1) throws CommandSyntaxException;
    }

    static class BlockPredicate
    implements Predicate<CachedBlockInfo> {
        private final BlockState state;
        private final Set<Property<?>> properties;
        @Nullable
        private final CompoundNBT nbt;

        public BlockPredicate(BlockState stateIn, Set<Property<?>> propertiesIn, @Nullable CompoundNBT nbtIn) {
            this.state = stateIn;
            this.properties = propertiesIn;
            this.nbt = nbtIn;
        }

        @Override
        public boolean test(CachedBlockInfo p_test_1_) {
            BlockState blockstate = p_test_1_.getBlockState();
            if (!blockstate.isIn(this.state.getBlock())) {
                return false;
            }
            for (Property<?> property : this.properties) {
                if (blockstate.get(property) == this.state.get(property)) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            TileEntity tileentity = p_test_1_.getTileEntity();
            return tileentity != null && NBTUtil.areNBTEquals(this.nbt, tileentity.write(new CompoundNBT()), true);
        }
    }
}

