/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;

public class SignTileEntityRenderer
extends TileEntityRenderer<SignTileEntity> {
    private final SignModel model = new SignModel();
    private static double textRenderDistanceSq = 4096.0;

    public SignTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @Override
    public void render(SignTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = tileEntityIn.getBlockState();
        matrixStackIn.push();
        float f = 0.6666667f;
        if (blockstate.getBlock() instanceof StandingSignBlock) {
            matrixStackIn.translate(0.5, 0.5, 0.5);
            float f1 = -((float)(blockstate.get(StandingSignBlock.ROTATION) * 360) / 16.0f);
            matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f1));
            this.model.signStick.showModel = true;
        } else {
            matrixStackIn.translate(0.5, 0.5, 0.5);
            float f4 = -blockstate.get(WallSignBlock.FACING).getHorizontalAngle();
            matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f4));
            matrixStackIn.translate(0.0, -0.3125, -0.4375);
            this.model.signStick.showModel = false;
        }
        matrixStackIn.push();
        matrixStackIn.scale(0.6666667f, -0.6666667f, -0.6666667f);
        RenderMaterial rendermaterial = SignTileEntityRenderer.getMaterial(blockstate.getBlock());
        IVertexBuilder ivertexbuilder = rendermaterial.getBuffer(bufferIn, this.model::getRenderType);
        this.model.signBoard.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.model.signStick.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.pop();
        if (SignTileEntityRenderer.isRenderText(tileEntityIn)) {
            FontRenderer fontrenderer = this.renderDispatcher.getFontRenderer();
            float f2 = 0.010416667f;
            matrixStackIn.translate(0.0, 0.3333333432674408, 0.046666666865348816);
            matrixStackIn.scale(0.010416667f, -0.010416667f, 0.010416667f);
            int i = tileEntityIn.getTextColor().getTextColor();
            if (Config.isCustomColors()) {
                i = CustomColors.getSignTextColor(i);
            }
            double d0 = 0.4;
            int j = (int)((double)NativeImage.getRed(i) * 0.4);
            int k = (int)((double)NativeImage.getGreen(i) * 0.4);
            int l = (int)((double)NativeImage.getBlue(i) * 0.4);
            int i1 = NativeImage.getCombined(0, l, k, j);
            int j1 = 20;
            for (int k1 = 0; k1 < 4; ++k1) {
                IReorderingProcessor ireorderingprocessor = tileEntityIn.func_242686_a(k1, p_lambda$render$0_1_ -> {
                    List<IReorderingProcessor> list = fontrenderer.trimStringToWidth((ITextProperties)p_lambda$render$0_1_, 90);
                    return list.isEmpty() ? IReorderingProcessor.field_242232_a : list.get(0);
                });
                if (ireorderingprocessor == null) continue;
                float f3 = -fontrenderer.func_243245_a(ireorderingprocessor) / 2;
                fontrenderer.func_238416_a_(ireorderingprocessor, f3, k1 * 10 - 20, i1, false, matrixStackIn.getLast().getMatrix(), bufferIn, false, 0, combinedLightIn);
            }
        }
        matrixStackIn.pop();
    }

    public static RenderMaterial getMaterial(Block blockIn) {
        WoodType woodtype = blockIn instanceof AbstractSignBlock ? ((AbstractSignBlock)blockIn).getWoodType() : WoodType.OAK;
        return Atlases.SIGN_MATERIALS.get(woodtype);
    }

    private static boolean isRenderText(SignTileEntity p_isRenderText_0_) {
        if (Shaders.isShadowPass) {
            return false;
        }
        if (!Config.zoomMode) {
            BlockPos blockpos = p_isRenderText_0_.getPos();
            Entity entity = Minecraft.getInstance().getRenderViewEntity();
            double d0 = entity.getDistanceSq(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            if (d0 > textRenderDistanceSq) {
                return false;
            }
        }
        return true;
    }

    public static void updateTextRenderDistance() {
        Minecraft minecraft = Minecraft.getInstance();
        double d0 = Config.limit(minecraft.gameSettings.fov, 1.0, 120.0);
        double d1 = Math.max(1.5 * (double)minecraft.getMainWindow().getHeight() / d0, 16.0);
        textRenderDistanceSq = d1 * d1;
    }

    public static final class SignModel
    extends Model {
        public final ModelRenderer signBoard = new ModelRenderer(64, 32, 0, 0);
        public final ModelRenderer signStick;

        public SignModel() {
            super(RenderType::getEntityCutoutNoCull);
            this.signBoard.addBox(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f, 0.0f);
            this.signStick = new ModelRenderer(64, 32, 0, 14);
            this.signStick.addBox(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f);
        }

        @Override
        public void render(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.signBoard.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.signStick.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

