/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.optifine.Config;
import net.optifine.shaders.ShadersRender;

public class EndPortalTileEntityRenderer<T extends EndPortalTileEntity>
extends TileEntityRenderer<T> {
    public static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    public static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = IntStream.range(0, 16).mapToObj(p_lambda$static$0_0_ -> RenderType.getEndPortal(p_lambda$static$0_0_ + 1)).collect(ImmutableList.toImmutableList());

    public EndPortalTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @Override
    public void render(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!Config.isShaders() || !ShadersRender.renderEndPortal(tileEntityIn, partialTicks, this.getOffset(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn)) {
            RANDOM.setSeed(31100L);
            double d0 = ((TileEntity)tileEntityIn).getPos().distanceSq(this.renderDispatcher.renderInfo.getProjectedView(), true);
            int i = this.getPasses(d0);
            float f = this.getOffset();
            Matrix4f matrix4f = matrixStackIn.getLast().getMatrix();
            this.renderCube(tileEntityIn, f, 0.15f, matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(0)));
            for (int j = 1; j < i; ++j) {
                this.renderCube(tileEntityIn, f, 2.0f / (float)(18 - j), matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(j)));
            }
        }
    }

    private void renderCube(T tileEntityIn, float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, IVertexBuilder p_228883_5_) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, f, f1, f2, Direction.SOUTH);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f, f1, f2, Direction.NORTH);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2, Direction.EAST);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2, Direction.WEST);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f, f1, f2, Direction.DOWN);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, p_228883_2_, p_228883_2_, 1.0f, 1.0f, 0.0f, 0.0f, f, f1, f2, Direction.UP);
    }

    private void renderFace(T tileEntityIn, Matrix4f p_228884_2_, IVertexBuilder p_228884_3_, float p_228884_4_, float p_228884_5_, float p_228884_6_, float p_228884_7_, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float p_228884_12_, float p_228884_13_, float p_228884_14_, Direction p_228884_15_) {
        if (((EndPortalTileEntity)tileEntityIn).shouldRenderFace(p_228884_15_)) {
            p_228884_3_.pos(p_228884_2_, p_228884_4_, p_228884_6_, p_228884_8_).color(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).endVertex();
            p_228884_3_.pos(p_228884_2_, p_228884_5_, p_228884_6_, p_228884_9_).color(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).endVertex();
            p_228884_3_.pos(p_228884_2_, p_228884_5_, p_228884_7_, p_228884_10_).color(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).endVertex();
            p_228884_3_.pos(p_228884_2_, p_228884_4_, p_228884_7_, p_228884_11_).color(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).endVertex();
        }
    }

    protected int getPasses(double p_191286_1_) {
        if (p_191286_1_ > 36864.0) {
            return 1;
        }
        if (p_191286_1_ > 25600.0) {
            return 3;
        }
        if (p_191286_1_ > 16384.0) {
            return 5;
        }
        if (p_191286_1_ > 9216.0) {
            return 7;
        }
        if (p_191286_1_ > 4096.0) {
            return 9;
        }
        if (p_191286_1_ > 1024.0) {
            return 11;
        }
        if (p_191286_1_ > 576.0) {
            return 13;
        }
        return p_191286_1_ > 256.0 ? 14 : 15;
    }

    protected float getOffset() {
        return 0.75f;
    }
}

