/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EndGatewayTileEntityRenderer
extends EndPortalTileEntityRenderer<EndGatewayTileEntity> {
    private static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");

    public EndGatewayTileEntityRenderer(TileEntityRendererDispatcher p_i226018_1_) {
        super(p_i226018_1_);
    }

    @Override
    public void render(EndGatewayTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.isSpawning() || tileEntityIn.isCoolingDown()) {
            float f = tileEntityIn.isSpawning() ? tileEntityIn.getSpawnPercent(partialTicks) : tileEntityIn.getCooldownPercent(partialTicks);
            double d0 = tileEntityIn.isSpawning() ? 256.0 : 50.0;
            f = MathHelper.sin(f * (float)Math.PI);
            int i = MathHelper.floor((double)f * d0);
            float[] afloat = tileEntityIn.isSpawning() ? DyeColor.MAGENTA.getColorComponentValues() : DyeColor.PURPLE.getColorComponentValues();
            long j = tileEntityIn.getWorld().getGameTime();
            BeaconTileEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, END_GATEWAY_BEAM_TEXTURE, partialTicks, f, j, 0, i, afloat, 0.15f, 0.175f);
            BeaconTileEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, END_GATEWAY_BEAM_TEXTURE, partialTicks, f, j, 0, -i, afloat, 0.15f, 0.175f);
        }
        super.render(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected int getPasses(double p_191286_1_) {
        return super.getPasses(p_191286_1_) + 1;
    }

    @Override
    protected float getOffset() {
        return 1.0f;
    }
}

