/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.MinecartModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class MinecartRenderer<T extends AbstractMinecartEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation MINECART_TEXTURES = new ResourceLocation("textures/entity/minecart.png");
    protected final EntityModel<T> modelMinecart = new MinecartModel();

    public MinecartRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.shadowSize = 0.7f;
    }

    @Override
    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.push();
        long i = (long)((Entity)entityIn).getEntityId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStackIn.translate(f, f1, f2);
        double d0 = MathHelper.lerp((double)partialTicks, ((AbstractMinecartEntity)entityIn).lastTickPosX, ((Entity)entityIn).getPosX());
        double d1 = MathHelper.lerp((double)partialTicks, ((AbstractMinecartEntity)entityIn).lastTickPosY, ((Entity)entityIn).getPosY());
        double d2 = MathHelper.lerp((double)partialTicks, ((AbstractMinecartEntity)entityIn).lastTickPosZ, ((Entity)entityIn).getPosZ());
        double d3 = 0.3f;
        Vector3d vector3d = ((AbstractMinecartEntity)entityIn).getPos(d0, d1, d2);
        float f3 = MathHelper.lerp(partialTicks, ((AbstractMinecartEntity)entityIn).prevRotationPitch, ((AbstractMinecartEntity)entityIn).rotationPitch);
        if (vector3d != null) {
            Vector3d vector3d1 = ((AbstractMinecartEntity)entityIn).getPosOffset(d0, d1, d2, 0.3f);
            Vector3d vector3d2 = ((AbstractMinecartEntity)entityIn).getPosOffset(d0, d1, d2, -0.3f);
            if (vector3d1 == null) {
                vector3d1 = vector3d;
            }
            if (vector3d2 == null) {
                vector3d2 = vector3d;
            }
            matrixStackIn.translate(vector3d.x - d0, (vector3d1.y + vector3d2.y) / 2.0 - d1, vector3d.z - d2);
            Vector3d vector3d3 = vector3d2.add(-vector3d1.x, -vector3d1.y, -vector3d1.z);
            if (vector3d3.length() != 0.0) {
                vector3d3 = vector3d3.normalize();
                entityYaw = (float)(Math.atan2(vector3d3.z, vector3d3.x) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vector3d3.y) * 73.0);
            }
        }
        matrixStackIn.translate(0.0, 0.375, 0.0);
        matrixStackIn.rotate(Vector3f.YP.rotationDegrees(180.0f - entityYaw));
        matrixStackIn.rotate(Vector3f.ZP.rotationDegrees(-f3));
        float f5 = (float)((AbstractMinecartEntity)entityIn).getRollingAmplitude() - partialTicks;
        float f6 = ((AbstractMinecartEntity)entityIn).getDamage() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            matrixStackIn.rotate(Vector3f.XP.rotationDegrees(MathHelper.sin(f5) * f5 * f6 / 10.0f * (float)((AbstractMinecartEntity)entityIn).getRollingDirection()));
        }
        int j = ((AbstractMinecartEntity)entityIn).getDisplayTileOffset();
        BlockState blockstate = ((AbstractMinecartEntity)entityIn).getDisplayTile();
        if (blockstate.getRenderType() != BlockRenderType.INVISIBLE) {
            matrixStackIn.push();
            float f4 = 0.75f;
            matrixStackIn.scale(0.75f, 0.75f, 0.75f);
            matrixStackIn.translate(-0.5, (float)(j - 8) / 16.0f, 0.5);
            matrixStackIn.rotate(Vector3f.YP.rotationDegrees(90.0f));
            this.renderBlockState(entityIn, partialTicks, blockstate, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.pop();
        }
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.modelMinecart.setRotationAngles(entityIn, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.modelMinecart.getRenderType(this.getEntityTexture(entityIn)));
        this.modelMinecart.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.pop();
    }

    @Override
    public ResourceLocation getEntityTexture(T entity) {
        return MINECART_TEXTURES;
    }

    protected void renderBlockState(T entityIn, float partialTicks, BlockState stateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Minecraft.getInstance().getBlockRendererDispatcher().renderBlock(stateIn, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY);
    }
}

