/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class FishRenderer
extends EntityRenderer<FishingBobberEntity> {
    private static final ResourceLocation BOBBER = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType field_229103_e_ = RenderType.getEntityCutout(BOBBER);

    public FishRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void render(FishingBobberEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        PlayerEntity playerentity = entityIn.func_234606_i_();
        if (playerentity != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            matrixStackIn.push();
            matrixStackIn.push();
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            matrixStackIn.rotate(this.renderManager.getCameraOrientation());
            matrixStackIn.rotate(Vector3f.YP.rotationDegrees(180.0f));
            MatrixStack.Entry matrixstack$entry = matrixStackIn.getLast();
            Matrix4f matrix4f = matrixstack$entry.getMatrix();
            Matrix3f matrix3f = matrixstack$entry.getNormal();
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(field_229103_e_);
            FishRenderer.func_229106_a_(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 0.0f, 0, 0, 1);
            FishRenderer.func_229106_a_(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 1.0f, 0, 1, 1);
            FishRenderer.func_229106_a_(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 1.0f, 1, 1, 0);
            FishRenderer.func_229106_a_(ivertexbuilder, matrix4f, matrix3f, packedLightIn, 0.0f, 1, 0, 0);
            matrixStackIn.pop();
            int i = playerentity.getPrimaryHand() == HandSide.RIGHT ? 1 : -1;
            ItemStack itemstack = playerentity.getHeldItemMainhand();
            if (itemstack.getItem() != Items.FISHING_ROD) {
                i = -i;
            }
            float f = playerentity.getSwingProgress(partialTicks);
            float f1 = MathHelper.sin(MathHelper.sqrt(f) * (float)Math.PI);
            float f2 = MathHelper.lerp(partialTicks, playerentity.prevRenderYawOffset, playerentity.renderYawOffset) * ((float)Math.PI / 180);
            double d0 = MathHelper.sin(f2);
            double d1 = MathHelper.cos(f2);
            double d2 = (double)i * 0.35;
            double d3 = 0.8;
            if ((this.renderManager.options == null || this.renderManager.options.getPointOfView().func_243192_a()) && playerentity == Minecraft.getInstance().player) {
                double d7 = this.renderManager.options.fov;
                Vector3d vector3d = new Vector3d((double)i * -0.36 * (d7 /= 100.0), -0.045 * d7, 0.4);
                vector3d = vector3d.rotatePitch(-MathHelper.lerp(partialTicks, playerentity.prevRotationPitch, playerentity.rotationPitch) * ((float)Math.PI / 180));
                vector3d = vector3d.rotateYaw(-MathHelper.lerp(partialTicks, playerentity.prevRotationYaw, playerentity.rotationYaw) * ((float)Math.PI / 180));
                vector3d = vector3d.rotateYaw(f1 * 0.5f);
                vector3d = vector3d.rotatePitch(-f1 * 0.7f);
                d4 = MathHelper.lerp((double)partialTicks, playerentity.prevPosX, playerentity.getPosX()) + vector3d.x;
                d5 = MathHelper.lerp((double)partialTicks, playerentity.prevPosY, playerentity.getPosY()) + vector3d.y;
                d6 = MathHelper.lerp((double)partialTicks, playerentity.prevPosZ, playerentity.getPosZ()) + vector3d.z;
                f3 = playerentity.getEyeHeight();
            } else {
                d4 = MathHelper.lerp((double)partialTicks, playerentity.prevPosX, playerentity.getPosX()) - d1 * d2 - d0 * 0.8;
                d5 = playerentity.prevPosY + (double)playerentity.getEyeHeight() + (playerentity.getPosY() - playerentity.prevPosY) * (double)partialTicks - 0.45;
                d6 = MathHelper.lerp((double)partialTicks, playerentity.prevPosZ, playerentity.getPosZ()) - d0 * d2 + d1 * 0.8;
                f3 = playerentity.isCrouching() ? -0.1875f : 0.0f;
            }
            double d9 = MathHelper.lerp((double)partialTicks, entityIn.prevPosX, entityIn.getPosX());
            double d10 = MathHelper.lerp((double)partialTicks, entityIn.prevPosY, entityIn.getPosY()) + 0.25;
            double d8 = MathHelper.lerp((double)partialTicks, entityIn.prevPosZ, entityIn.getPosZ());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(RenderType.getLines());
            Matrix4f matrix4f1 = matrixStackIn.getLast().getMatrix();
            int j = 16;
            for (int k = 0; k < 16; ++k) {
                FishRenderer.func_229104_a_(f4, f5, f6, ivertexbuilder1, matrix4f1, FishRenderer.func_229105_a_(k, 16));
                FishRenderer.func_229104_a_(f4, f5, f6, ivertexbuilder1, matrix4f1, FishRenderer.func_229105_a_(k + 1, 16));
            }
            matrixStackIn.pop();
            super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private static float func_229105_a_(int p_229105_0_, int p_229105_1_) {
        return (float)p_229105_0_ / (float)p_229105_1_;
    }

    private static void func_229106_a_(IVertexBuilder p_229106_0_, Matrix4f p_229106_1_, Matrix3f p_229106_2_, int p_229106_3_, float p_229106_4_, int p_229106_5_, int p_229106_6_, int p_229106_7_) {
        p_229106_0_.pos(p_229106_1_, p_229106_4_ - 0.5f, (float)p_229106_5_ - 0.5f, 0.0f).color(255, 255, 255, 255).tex(p_229106_6_, p_229106_7_).overlay(OverlayTexture.NO_OVERLAY).lightmap(p_229106_3_).normal(p_229106_2_, 0.0f, 1.0f, 0.0f).endVertex();
    }

    private static void func_229104_a_(float p_229104_0_, float p_229104_1_, float p_229104_2_, IVertexBuilder p_229104_3_, Matrix4f p_229104_4_, float p_229104_5_) {
        p_229104_3_.pos(p_229104_4_, p_229104_0_ * p_229104_5_, p_229104_1_ * (p_229104_5_ * p_229104_5_ + p_229104_5_) * 0.5f + 0.25f, p_229104_2_ * p_229104_5_).color(0, 0, 0, 255).endVertex();
    }

    @Override
    public ResourceLocation getEntityTexture(FishingBobberEntity entity) {
        return BOBBER;
    }
}

