/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.LightType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.Either;

public abstract class EntityRenderer<T extends Entity>
implements IEntityRenderer {
    protected final EntityRendererManager renderManager;
    public float shadowSize;
    protected float shadowOpaque = 1.0f;
    private EntityType entityType = null;
    private ResourceLocation locationTextureCustom = null;

    protected EntityRenderer(EntityRendererManager renderManager) {
        this.renderManager = renderManager;
    }

    public final int getPackedLight(T entityIn, float partialTicks) {
        BlockPos blockpos = new BlockPos(((Entity)entityIn).func_241842_k(partialTicks));
        return LightTexture.packLight(this.getBlockLight(entityIn, blockpos), this.func_239381_b_(entityIn, blockpos));
    }

    protected int func_239381_b_(T p_239381_1_, BlockPos p_239381_2_) {
        return ((Entity)p_239381_1_).world.getLightFor(LightType.SKY, p_239381_2_);
    }

    protected int getBlockLight(T entityIn, BlockPos partialTicks) {
        return ((Entity)entityIn).isBurning() ? 15 : ((Entity)entityIn).world.getLightFor(LightType.BLOCK, partialTicks);
    }

    public boolean shouldRender(T livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (!((Entity)livingEntityIn).isInRangeToRender3d(camX, camY, camZ)) {
            return false;
        }
        if (((Entity)livingEntityIn).ignoreFrustumCheck) {
            return true;
        }
        AxisAlignedBB axisalignedbb = ((Entity)livingEntityIn).getRenderBoundingBox().grow(0.5);
        if (axisalignedbb.hasNaN() || axisalignedbb.getAverageEdgeLength() == 0.0) {
            axisalignedbb = new AxisAlignedBB(((Entity)livingEntityIn).getPosX() - 2.0, ((Entity)livingEntityIn).getPosY() - 2.0, ((Entity)livingEntityIn).getPosZ() - 2.0, ((Entity)livingEntityIn).getPosX() + 2.0, ((Entity)livingEntityIn).getPosY() + 2.0, ((Entity)livingEntityIn).getPosZ() + 2.0);
        }
        return camera.isBoundingBoxInFrustum(axisalignedbb);
    }

    public Vector3d getRenderOffset(T entityIn, float partialTicks) {
        return Vector3d.ZERO;
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!Reflector.RenderNameplateEvent_Constructor.exists()) {
            if (this.canRenderName(entityIn)) {
                this.renderName(entityIn, ((Entity)entityIn).getDisplayName(), matrixStackIn, bufferIn, packedLightIn);
            }
        } else {
            Object object = Reflector.newInstance(Reflector.RenderNameplateEvent_Constructor, entityIn, ((Entity)entityIn).getDisplayName(), this, matrixStackIn, bufferIn, packedLightIn, Float.valueOf(partialTicks));
            Reflector.postForgeBusEvent(object);
            Object object1 = Reflector.call(object, Reflector.Event_getResult, new Object[0]);
            if (object1 != ReflectorForge.EVENT_RESULT_DENY && (object1 == ReflectorForge.EVENT_RESULT_ALLOW || this.canRenderName(entityIn))) {
                ITextComponent itextcomponent = (ITextComponent)Reflector.call(object, Reflector.RenderNameplateEvent_getContent, new Object[0]);
                this.renderName(entityIn, itextcomponent, matrixStackIn, bufferIn, packedLightIn);
            }
        }
    }

    protected boolean canRenderName(T entity) {
        return ((Entity)entity).getAlwaysRenderNameTagForRender() && ((Entity)entity).hasCustomName();
    }

    public abstract ResourceLocation getEntityTexture(T var1);

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }

    protected void renderName(T entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean flag;
        double d0 = this.renderManager.squareDistanceTo((Entity)entityIn);
        boolean bl = flag = !(d0 > 4096.0);
        if (Reflector.ForgeHooksClient_isNameplateInRenderDistance.exists()) {
            flag = Reflector.ForgeHooksClient_isNameplateInRenderDistance.callBoolean(entityIn, d0);
        }
        if (flag) {
            boolean flag1 = !((Entity)entityIn).isDiscrete();
            float f = ((Entity)entityIn).getHeight() + 0.5f;
            int i = "deadmau5".equals(displayNameIn.getString()) ? -10 : 0;
            matrixStackIn.push();
            matrixStackIn.translate(0.0, f, 0.0);
            matrixStackIn.rotate(this.renderManager.getCameraOrientation());
            matrixStackIn.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.getLast().getMatrix();
            float f1 = Minecraft.getInstance().gameSettings.getTextBackgroundOpacity(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
            float f2 = -fontrenderer.getStringPropertyWidth(displayNameIn) / 2;
            fontrenderer.func_243247_a(displayNameIn, f2, i, 0x20FFFFFF, false, matrix4f, bufferIn, flag1, j, packedLightIn);
            if (flag1) {
                fontrenderer.func_243247_a(displayNameIn, f2, i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.pop();
        }
    }

    public EntityRendererManager getRenderManager() {
        return this.renderManager;
    }

    @Override
    public Either<EntityType, TileEntityType> getType() {
        return this.entityType == null ? null : Either.makeLeft(this.entityType);
    }

    @Override
    public void setType(Either<EntityType, TileEntityType> p_setType_1_) {
        this.entityType = p_setType_1_.getLeft().get();
    }

    @Override
    public ResourceLocation getLocationTextureCustom() {
        return this.locationTextureCustom;
    }

    @Override
    public void setLocationTextureCustom(ResourceLocation p_setLocationTextureCustom_1_) {
        this.locationTextureCustom = p_setLocationTextureCustom_1_;
    }
}

