/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;

public class WorldGenAttemptsDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final List<BlockPos> locations = Lists.newArrayList();
    private final List<Float> sizes = Lists.newArrayList();
    private final List<Float> alphas = Lists.newArrayList();
    private final List<Float> reds = Lists.newArrayList();
    private final List<Float> greens = Lists.newArrayList();
    private final List<Float> blues = Lists.newArrayList();

    public void addAttempt(BlockPos pos, float size, float red, float green, float blue, float alpha) {
        this.locations.add(pos);
        this.sizes.add(Float.valueOf(size));
        this.alphas.add(Float.valueOf(alpha));
        this.reds.add(Float.valueOf(red));
        this.greens.add(Float.valueOf(green));
        this.blues.add(Float.valueOf(blue));
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, double camX, double camY, double camZ) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(5, DefaultVertexFormats.POSITION_COLOR);
        for (int i = 0; i < this.locations.size(); ++i) {
            BlockPos blockpos = this.locations.get(i);
            Float f = this.sizes.get(i);
            float f1 = f.floatValue() / 2.0f;
            WorldRenderer.addChainedFilledBoxVertices(bufferbuilder, (double)((float)blockpos.getX() + 0.5f - f1) - camX, (double)((float)blockpos.getY() + 0.5f - f1) - camY, (double)((float)blockpos.getZ() + 0.5f - f1) - camZ, (double)((float)blockpos.getX() + 0.5f + f1) - camX, (double)((float)blockpos.getY() + 0.5f + f1) - camY, (double)((float)blockpos.getZ() + 0.5f + f1) - camZ, this.reds.get(i).floatValue(), this.greens.get(i).floatValue(), this.blues.get(i).floatValue(), this.alphas.get(i).floatValue());
        }
        tessellator.draw();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }
}

