/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.DimensionType;

public class StructureDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft minecraft;
    private final Map<DimensionType, Map<String, MutableBoundingBox>> mainBoxes = Maps.newIdentityHashMap();
    private final Map<DimensionType, Map<String, MutableBoundingBox>> subBoxes = Maps.newIdentityHashMap();
    private final Map<DimensionType, Map<String, Boolean>> subBoxFlags = Maps.newIdentityHashMap();

    public StructureDebugRenderer(Minecraft minecraftIn) {
        this.minecraft = minecraftIn;
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, double camX, double camY, double camZ) {
        ActiveRenderInfo activerenderinfo = this.minecraft.gameRenderer.getActiveRenderInfo();
        ClientWorld iworld = this.minecraft.world;
        DimensionType dimensiontype = iworld.getDimensionType();
        BlockPos blockpos = new BlockPos(activerenderinfo.getProjectedView().x, 0.0, activerenderinfo.getProjectedView().z);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.getLines());
        if (this.mainBoxes.containsKey(dimensiontype)) {
            for (MutableBoundingBox mutableBoundingBox : this.mainBoxes.get(dimensiontype).values()) {
                if (!blockpos.withinDistance(mutableBoundingBox.func_215126_f(), 500.0)) continue;
                WorldRenderer.drawBoundingBox(matrixStackIn, ivertexbuilder, (double)mutableBoundingBox.minX - camX, (double)mutableBoundingBox.minY - camY, (double)mutableBoundingBox.minZ - camZ, (double)(mutableBoundingBox.maxX + 1) - camX, (double)(mutableBoundingBox.maxY + 1) - camY, (double)(mutableBoundingBox.maxZ + 1) - camZ, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.subBoxes.containsKey(dimensiontype)) {
            for (Map.Entry entry : this.subBoxes.get(dimensiontype).entrySet()) {
                String s = (String)entry.getKey();
                MutableBoundingBox mutableboundingbox1 = (MutableBoundingBox)entry.getValue();
                Boolean obool = this.subBoxFlags.get(dimensiontype).get(s);
                if (!blockpos.withinDistance(mutableboundingbox1.func_215126_f(), 500.0)) continue;
                if (obool.booleanValue()) {
                    WorldRenderer.drawBoundingBox(matrixStackIn, ivertexbuilder, (double)mutableboundingbox1.minX - camX, (double)mutableboundingbox1.minY - camY, (double)mutableboundingbox1.minZ - camZ, (double)(mutableboundingbox1.maxX + 1) - camX, (double)(mutableboundingbox1.maxY + 1) - camY, (double)(mutableboundingbox1.maxZ + 1) - camZ, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                    continue;
                }
                WorldRenderer.drawBoundingBox(matrixStackIn, ivertexbuilder, (double)mutableboundingbox1.minX - camX, (double)mutableboundingbox1.minY - camY, (double)mutableboundingbox1.minZ - camZ, (double)(mutableboundingbox1.maxX + 1) - camX, (double)(mutableboundingbox1.maxY + 1) - camY, (double)(mutableboundingbox1.maxZ + 1) - camZ, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public void func_223454_a(MutableBoundingBox p_223454_1_, List<MutableBoundingBox> p_223454_2_, List<Boolean> p_223454_3_, DimensionType p_223454_4_) {
        if (!this.mainBoxes.containsKey(p_223454_4_)) {
            this.mainBoxes.put(p_223454_4_, Maps.newHashMap());
        }
        if (!this.subBoxes.containsKey(p_223454_4_)) {
            this.subBoxes.put(p_223454_4_, Maps.newHashMap());
            this.subBoxFlags.put(p_223454_4_, Maps.newHashMap());
        }
        this.mainBoxes.get(p_223454_4_).put(p_223454_1_.toString(), p_223454_1_);
        for (int i = 0; i < p_223454_2_.size(); ++i) {
            MutableBoundingBox mutableboundingbox = p_223454_2_.get(i);
            Boolean obool = p_223454_3_.get(i);
            this.subBoxes.get(p_223454_4_).put(mutableboundingbox.toString(), mutableboundingbox);
            this.subBoxFlags.get(p_223454_4_).put(mutableboundingbox.toString(), obool);
        }
    }

    @Override
    public void clear() {
        this.mainBoxes.clear();
        this.subBoxes.clear();
        this.subBoxFlags.clear();
    }
}

