/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;

public class WhiteAshParticle
extends RisingParticle {
    protected WhiteAshParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, IAnimatedSprite spriteWithAge) {
        super(world, x, y, z, 0.1f, -0.1f, 0.1f, motionX, motionY, motionZ, scale, spriteWithAge, 0.0f, 20, -5.0E-4, false);
        this.particleRed = 0.7294118f;
        this.particleGreen = 0.69411767f;
        this.particleBlue = 0.7607843f;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random random = worldIn.rand;
            double d0 = (double)random.nextFloat() * -1.9 * (double)random.nextFloat() * 0.1;
            double d1 = (double)random.nextFloat() * -0.5 * (double)random.nextFloat() * 0.1 * 5.0;
            double d2 = (double)random.nextFloat() * -1.9 * (double)random.nextFloat() * 0.1;
            return new WhiteAshParticle(worldIn, x, y, z, d0, d1, d2, 1.0f, this.spriteSet);
        }
    }
}

