/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.MetaParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;

public class FireworkParticle {

    public static class Starter
    extends MetaParticle {
        private int fireworkAge;
        private final ParticleManager manager;
        private ListNBT fireworkExplosions;
        private boolean twinkle;

        public Starter(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleManager particleManager, @Nullable CompoundNBT p_i232391_15_) {
            super(world, x, y, z);
            this.motionX = motionX;
            this.motionY = motionY;
            this.motionZ = motionZ;
            this.manager = particleManager;
            this.maxAge = 8;
            if (p_i232391_15_ != null) {
                this.fireworkExplosions = p_i232391_15_.getList("Explosions", 10);
                if (this.fireworkExplosions.isEmpty()) {
                    this.fireworkExplosions = null;
                } else {
                    this.maxAge = this.fireworkExplosions.size() * 2 - 1;
                    for (int i = 0; i < this.fireworkExplosions.size(); ++i) {
                        CompoundNBT compoundnbt = this.fireworkExplosions.getCompound(i);
                        if (!compoundnbt.getBoolean("Flicker")) continue;
                        this.twinkle = true;
                        this.maxAge += 15;
                        break;
                    }
                }
            }
        }

        @Override
        public void tick() {
            if (this.fireworkAge == 0 && this.fireworkExplosions != null) {
                boolean flag = this.isFarFromCamera();
                boolean flag1 = false;
                if (this.fireworkExplosions.size() >= 3) {
                    flag1 = true;
                } else {
                    for (int i = 0; i < this.fireworkExplosions.size(); ++i) {
                        CompoundNBT compoundnbt = this.fireworkExplosions.getCompound(i);
                        if (FireworkRocketItem.Shape.get(compoundnbt.getByte("Type")) != FireworkRocketItem.Shape.LARGE_BALL) continue;
                        flag1 = true;
                        break;
                    }
                }
                SoundEvent soundevent1 = flag1 ? (flag ? SoundEvents.ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR : SoundEvents.ENTITY_FIREWORK_ROCKET_LARGE_BLAST) : (flag ? SoundEvents.ENTITY_FIREWORK_ROCKET_BLAST_FAR : SoundEvents.ENTITY_FIREWORK_ROCKET_BLAST);
                this.world.playSound(this.posX, this.posY, this.posZ, soundevent1, SoundCategory.AMBIENT, 20.0f, 0.95f + this.rand.nextFloat() * 0.1f, true);
            }
            if (this.fireworkAge % 2 == 0 && this.fireworkExplosions != null && this.fireworkAge / 2 < this.fireworkExplosions.size()) {
                int k = this.fireworkAge / 2;
                CompoundNBT compoundnbt1 = this.fireworkExplosions.getCompound(k);
                FireworkRocketItem.Shape fireworkrocketitem$shape = FireworkRocketItem.Shape.get(compoundnbt1.getByte("Type"));
                boolean flag4 = compoundnbt1.getBoolean("Trail");
                boolean flag2 = compoundnbt1.getBoolean("Flicker");
                int[] aint = compoundnbt1.getIntArray("Colors");
                int[] aint1 = compoundnbt1.getIntArray("FadeColors");
                if (aint.length == 0) {
                    aint = new int[]{DyeColor.BLACK.getFireworkColor()};
                }
                switch (fireworkrocketitem$shape) {
                    default: {
                        this.createBall(0.25, 2, aint, aint1, flag4, flag2);
                        break;
                    }
                    case LARGE_BALL: {
                        this.createBall(0.5, 4, aint, aint1, flag4, flag2);
                        break;
                    }
                    case STAR: {
                        this.createShaped(0.5, new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3795918367346939, -0.12653061224489795}, {0.6122448979591837, -0.8040816326530612}, {0.0, -0.35918367346938773}}, aint, aint1, flag4, flag2, false);
                        break;
                    }
                    case CREEPER: {
                        this.createShaped(0.5, new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}}, aint, aint1, flag4, flag2, true);
                        break;
                    }
                    case BURST: {
                        this.createBurst(aint, aint1, flag4, flag2);
                    }
                }
                int j = aint[0];
                float f = (float)((j & 0xFF0000) >> 16) / 255.0f;
                float f1 = (float)((j & 0xFF00) >> 8) / 255.0f;
                float f2 = (float)((j & 0xFF) >> 0) / 255.0f;
                Particle particle = this.manager.addParticle(ParticleTypes.FLASH, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
                particle.setColor(f, f1, f2);
            }
            ++this.fireworkAge;
            if (this.fireworkAge > this.maxAge) {
                if (this.twinkle) {
                    boolean flag3 = this.isFarFromCamera();
                    SoundEvent soundevent = flag3 ? SoundEvents.ENTITY_FIREWORK_ROCKET_TWINKLE_FAR : SoundEvents.ENTITY_FIREWORK_ROCKET_TWINKLE;
                    this.world.playSound(this.posX, this.posY, this.posZ, soundevent, SoundCategory.AMBIENT, 20.0f, 0.9f + this.rand.nextFloat() * 0.15f, true);
                }
                this.setExpired();
            }
        }

        private boolean isFarFromCamera() {
            Minecraft minecraft = Minecraft.getInstance();
            return minecraft.gameRenderer.getActiveRenderInfo().getProjectedView().squareDistanceTo(this.posX, this.posY, this.posZ) >= 256.0;
        }

        private void createParticle(double x, double y, double z, double motionX, double motionY, double motionZ, int[] sparkColors, int[] sparkColorFades, boolean hasTrail, boolean hasTwinkle) {
            Spark fireworkparticle$spark = (Spark)this.manager.addParticle(ParticleTypes.FIREWORK, x, y, z, motionX, motionY, motionZ);
            fireworkparticle$spark.setTrail(hasTrail);
            fireworkparticle$spark.setTwinkle(hasTwinkle);
            fireworkparticle$spark.setAlphaF(0.99f);
            int i = this.rand.nextInt(sparkColors.length);
            fireworkparticle$spark.setColor(sparkColors[i]);
            if (sparkColorFades.length > 0) {
                fireworkparticle$spark.setColorFade(Util.getRandomInt(sparkColorFades, this.rand));
            }
        }

        private void createBall(double speed, int size, int[] colours, int[] fadeColours, boolean trail, boolean twinkleIn) {
            double d0 = this.posX;
            double d1 = this.posY;
            double d2 = this.posZ;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double d6 = (double)MathHelper.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / speed + this.rand.nextGaussian() * 0.05;
                        this.createParticle(d0, d1, d2, d3 / d6, d4 / d6, d5 / d6, colours, fadeColours, trail, twinkleIn);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
        }

        private void createShaped(double speed, double[][] shape, int[] colours, int[] fadeColours, boolean trail, boolean twinkleIn, boolean p_92038_8_) {
            double d0 = shape[0][0];
            double d1 = shape[0][1];
            this.createParticle(this.posX, this.posY, this.posZ, d0 * speed, d1 * speed, 0.0, colours, fadeColours, trail, twinkleIn);
            float f = this.rand.nextFloat() * (float)Math.PI;
            double d2 = p_92038_8_ ? 0.034 : 0.34;
            for (int i = 0; i < 3; ++i) {
                double d3 = (double)f + (double)((float)i * (float)Math.PI) * d2;
                double d4 = d0;
                double d5 = d1;
                for (int j = 1; j < shape.length; ++j) {
                    double d6 = shape[j][0];
                    double d7 = shape[j][1];
                    for (double d8 = 0.25; d8 <= 1.0; d8 += 0.25) {
                        double d9 = MathHelper.lerp(d8, d4, d6) * speed;
                        double d10 = MathHelper.lerp(d8, d5, d7) * speed;
                        double d11 = d9 * Math.sin(d3);
                        d9 *= Math.cos(d3);
                        for (double d12 = -1.0; d12 <= 1.0; d12 += 2.0) {
                            this.createParticle(this.posX, this.posY, this.posZ, d9 * d12, d10, d11 * d12, colours, fadeColours, trail, twinkleIn);
                        }
                    }
                    d4 = d6;
                    d5 = d7;
                }
            }
        }

        private void createBurst(int[] colours, int[] fadeColours, boolean trail, boolean twinkleIn) {
            double d0 = this.rand.nextGaussian() * 0.05;
            double d1 = this.rand.nextGaussian() * 0.05;
            for (int i = 0; i < 70; ++i) {
                double d2 = this.motionX * 0.5 + this.rand.nextGaussian() * 0.15 + d0;
                double d3 = this.motionZ * 0.5 + this.rand.nextGaussian() * 0.15 + d1;
                double d4 = this.motionY * 0.5 + this.rand.nextDouble() * 0.5;
                this.createParticle(this.posX, this.posY, this.posZ, d2, d4, d3, colours, fadeColours, trail, twinkleIn);
            }
        }
    }

    public static class SparkFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public SparkFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Spark fireworkparticle$spark = new Spark(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.getInstance().particles, this.spriteSet);
            fireworkparticle$spark.setAlphaF(0.99f);
            return fireworkparticle$spark;
        }
    }

    static class Spark
    extends SimpleAnimatedParticle {
        private boolean trail;
        private boolean twinkle;
        private final ParticleManager effectRenderer;
        private float fadeColourRed;
        private float fadeColourGreen;
        private float fadeColourBlue;
        private boolean hasFadeColour;

        private Spark(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleManager particleManager, IAnimatedSprite spriteWithAge) {
            super(world, x, y, z, spriteWithAge, -0.004f);
            this.motionX = motionX;
            this.motionY = motionY;
            this.motionZ = motionZ;
            this.effectRenderer = particleManager;
            this.particleScale *= 0.75f;
            this.maxAge = 48 + this.rand.nextInt(12);
            this.selectSpriteWithAge(spriteWithAge);
        }

        public void setTrail(boolean trailIn) {
            this.trail = trailIn;
        }

        public void setTwinkle(boolean twinkleIn) {
            this.twinkle = twinkleIn;
        }

        @Override
        public void renderParticle(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
            if (!this.twinkle || this.age < this.maxAge / 3 || (this.age + this.maxAge) / 3 % 2 == 0) {
                super.renderParticle(buffer, renderInfo, partialTicks);
            }
        }

        @Override
        public void tick() {
            super.tick();
            if (this.trail && this.age < this.maxAge / 2 && (this.age + this.maxAge) % 2 == 0) {
                Spark fireworkparticle$spark = new Spark(this.world, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, this.effectRenderer, this.spriteWithAge);
                fireworkparticle$spark.setAlphaF(0.99f);
                fireworkparticle$spark.setColor(this.particleRed, this.particleGreen, this.particleBlue);
                fireworkparticle$spark.age = fireworkparticle$spark.maxAge / 2;
                if (this.hasFadeColour) {
                    fireworkparticle$spark.hasFadeColour = true;
                    fireworkparticle$spark.fadeColourRed = this.fadeColourRed;
                    fireworkparticle$spark.fadeColourGreen = this.fadeColourGreen;
                    fireworkparticle$spark.fadeColourBlue = this.fadeColourBlue;
                }
                fireworkparticle$spark.twinkle = this.twinkle;
                this.effectRenderer.addEffect(fireworkparticle$spark);
            }
        }
    }

    public static class OverlayFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public OverlayFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Overlay fireworkparticle$overlay = new Overlay(worldIn, x, y, z);
            fireworkparticle$overlay.selectSpriteRandomly(this.spriteSet);
            return fireworkparticle$overlay;
        }
    }

    public static class Overlay
    extends SpriteTexturedParticle {
        private Overlay(ClientWorld world, double x, double y, double z) {
            super(world, x, y, z);
            this.maxAge = 4;
        }

        @Override
        public IParticleRenderType getRenderType() {
            return IParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }

        @Override
        public void renderParticle(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
            this.setAlphaF(0.6f - ((float)this.age + partialTicks - 1.0f) * 0.25f * 0.5f);
            super.renderParticle(buffer, renderInfo, partialTicks);
        }

        @Override
        public float getScale(float scaleFactor) {
            return 7.1f * MathHelper.sin(((float)this.age + scaleFactor - 1.0f) * 0.25f * (float)Math.PI);
        }
    }
}

