/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.minerl.multiagent.RandomHelper;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;

public class DripParticle
extends SpriteTexturedParticle {
    private final Fluid fluid;
    protected boolean fullbright;

    private DripParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.fluid = fluid;
    }

    @Override
    public IParticleRenderType getRenderType() {
        return IParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public int getBrightnessForRender(float partialTick) {
        return this.fullbright ? 240 : super.getBrightnessForRender(partialTick);
    }

    @Override
    public void tick() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.ageParticle();
        if (!this.isExpired) {
            this.motionY -= (double)this.particleGravity;
            this.move(this.motionX, this.motionY, this.motionZ);
            this.updateMotion();
            if (!this.isExpired) {
                this.motionX *= (double)0.98f;
                this.motionY *= (double)0.98f;
                this.motionZ *= (double)0.98f;
                BlockPos blockpos = new BlockPos(this.posX, this.posY, this.posZ);
                FluidState fluidstate = this.world.getFluidState(blockpos);
                if (fluidstate.getFluid() == this.fluid && this.posY < (double)((float)blockpos.getY() + fluidstate.getActualHeight(this.world, blockpos))) {
                    this.setExpired();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.maxAge-- <= 0) {
            this.setExpired();
        }
    }

    protected void updateMotion() {
    }

    public static class LandingObsidianTearFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public LandingObsidianTearFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing dripparticle = new Landing(worldIn, x, y, z, Fluids.EMPTY);
            dripparticle.fullbright = true;
            dripparticle.maxAge = (int)(28.0 / (RandomHelper.randomDouble() * 0.8 + 0.2));
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    public static class LandingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public LandingLavaFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing dripparticle = new Landing(worldIn, x, y, z, Fluids.LAVA);
            dripparticle.setColor(1.0f, 0.2857143f, 0.083333336f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    public static class LandingHoneyFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public LandingHoneyFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing dripparticle = new Landing(worldIn, x, y, z, Fluids.EMPTY);
            dripparticle.maxAge = (int)(128.0 / (RandomHelper.randomDouble() * 0.8 + 0.2));
            dripparticle.setColor(0.522f, 0.408f, 0.082f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    static class Landing
    extends DripParticle {
        private Landing(ClientWorld world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.maxAge = (int)(16.0 / (RandomHelper.randomDouble() * 0.8 + 0.2));
        }
    }

    public static class FallingWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingWaterFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquidParticle dripparticle = new FallingLiquidParticle(worldIn, x, y, z, Fluids.WATER, ParticleTypes.SPLASH);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    public static class FallingObsidianTearFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingObsidianTearFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquidParticle dripparticle = new FallingLiquidParticle(worldIn, x, y, z, Fluids.EMPTY, ParticleTypes.LANDING_OBSIDIAN_TEAR);
            dripparticle.fullbright = true;
            dripparticle.particleGravity = 0.01f;
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    static class FallingNectarParticle
    extends DripParticle {
        private FallingNectarParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.maxAge = (int)(64.0 / (RandomHelper.randomDouble() * 0.8 + 0.2));
        }

        @Override
        protected void updateMotion() {
            if (this.onGround) {
                this.setExpired();
            }
        }
    }

    public static class FallingNectarFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingNectarFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingNectarParticle dripparticle = new FallingNectarParticle(worldIn, x, y, z, Fluids.EMPTY);
            dripparticle.maxAge = (int)(16.0 / (RandomHelper.randomDouble() * 0.8 + 0.2));
            dripparticle.particleGravity = 0.007f;
            dripparticle.setColor(0.92f, 0.782f, 0.72f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    static class FallingLiquidParticle
    extends FallingNectarParticle {
        protected final IParticleData particleData;

        private FallingLiquidParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid);
            this.particleData = particleData;
        }

        @Override
        protected void updateMotion() {
            if (this.onGround) {
                this.setExpired();
                this.world.addParticle(this.particleData, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class FallingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingLavaFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquidParticle dripparticle = new FallingLiquidParticle(worldIn, x, y, z, Fluids.LAVA, ParticleTypes.LANDING_LAVA);
            dripparticle.setColor(1.0f, 0.2857143f, 0.083333336f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    static class FallingHoneyParticle
    extends FallingLiquidParticle {
        private FallingHoneyParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid, particleData);
        }

        @Override
        protected void updateMotion() {
            if (this.onGround) {
                this.setExpired();
                this.world.addParticle(this.particleData, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
                this.world.playSound(this.posX + 0.5, this.posY, this.posZ + 0.5, SoundEvents.BLOCK_BEEHIVE_DROP, SoundCategory.BLOCKS, 0.3f + this.world.rand.nextFloat() * 2.0f / 3.0f, 1.0f, false);
            }
        }
    }

    public static class FallingHoneyFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FallingHoneyFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingHoneyParticle dripparticle = new FallingHoneyParticle(worldIn, x, y, z, Fluids.EMPTY, ParticleTypes.LANDING_HONEY);
            dripparticle.particleGravity = 0.01f;
            dripparticle.setColor(0.582f, 0.448f, 0.082f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    public static class DrippingWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DrippingWaterFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripparticle = new Dripping(worldIn, x, y, z, Fluids.WATER, ParticleTypes.FALLING_WATER);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.selectSpriteRandomly(this.spriteSet);
            return dripparticle;
        }
    }

    public static class DrippingObsidianTearFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DrippingObsidianTearFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripparticle$dripping = new Dripping(worldIn, x, y, z, Fluids.EMPTY, ParticleTypes.FALLING_OBSIDIAN_TEAR);
            dripparticle$dripping.fullbright = true;
            dripparticle$dripping.particleGravity *= 0.01f;
            dripparticle$dripping.maxAge = 100;
            dripparticle$dripping.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle$dripping.selectSpriteRandomly(this.spriteSet);
            return dripparticle$dripping;
        }
    }

    public static class DrippingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DrippingLavaFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DrippingLava dripparticle$drippinglava = new DrippingLava(worldIn, x, y, z, Fluids.LAVA, ParticleTypes.FALLING_LAVA);
            dripparticle$drippinglava.selectSpriteRandomly(this.spriteSet);
            return dripparticle$drippinglava;
        }
    }

    static class DrippingLava
    extends Dripping {
        private DrippingLava(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid, particleData);
        }

        @Override
        protected void ageParticle() {
            this.particleRed = 1.0f;
            this.particleGreen = 16.0f / (float)(40 - this.maxAge + 16);
            this.particleBlue = 4.0f / (float)(40 - this.maxAge + 8);
            super.ageParticle();
        }
    }

    public static class DrippingHoneyFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteWithAge;

        public DrippingHoneyFactory(IAnimatedSprite spriteWithAge) {
            this.spriteWithAge = spriteWithAge;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripparticle$dripping = new Dripping(worldIn, x, y, z, Fluids.EMPTY, ParticleTypes.FALLING_HONEY);
            dripparticle$dripping.particleGravity *= 0.01f;
            dripparticle$dripping.maxAge = 100;
            dripparticle$dripping.setColor(0.622f, 0.508f, 0.082f);
            dripparticle$dripping.selectSpriteRandomly(this.spriteWithAge);
            return dripparticle$dripping;
        }
    }

    static class Dripping
    extends DripParticle {
        private final IParticleData particleData;

        private Dripping(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid);
            this.particleData = particleData;
            this.particleGravity *= 0.02f;
            this.maxAge = 40;
        }

        @Override
        protected void ageParticle() {
            if (this.maxAge-- <= 0) {
                this.setExpired();
                this.world.addParticle(this.particleData, this.posX, this.posY, this.posZ, this.motionX, this.motionY, this.motionZ);
            }
        }

        @Override
        protected void updateMotion() {
            this.motionX *= 0.02;
            this.motionY *= 0.02;
            this.motionZ *= 0.02;
        }
    }
}

